% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_get_capacity_reservation_usage}
\alias{ec2_get_capacity_reservation_usage}
\title{Get Capacity Reservation Usage}
\usage{
ec2_get_capacity_reservation_usage(
  CapacityReservationId,
  NextToken = NULL,
  MaxResults = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{CapacityReservationId}{String. The ID of the Capacity Reservation.}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{MaxResults}{Integer.   The maximum number of results to return for the request in a single page.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Gets
usage information about a Capacity Reservation. If the Capacity
Reservation is shared, it shows usage information for the Capacity
Reservation owner and each AWS account that is currently using the
shared capacity. If the Capacity Reservation is not shared, it shows
only the Capacity Reservation owner\'s
usage.
}
\section{CapacityReservationId}{

The ID of
the Capacity Reservation.
}

\section{MaxResults}{


The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the returned \code{nextToken} value. This value can be between 5 and 500. If
\code{maxResults} is given a larger value than 500, you receive an error.

Valid range: Minimum value of 1. Maximum value of 1000.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

