% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_transit_gateway}
\alias{ec2_modify_transit_gateway}
\title{Modify Transit Gateway}
\usage{
ec2_modify_transit_gateway(
  TransitGatewayId,
  Description = NULL,
  Options = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayId}{String. The ID of the transit gateway.}

\item{Description}{String. The description for the transit gateway.[optional]}

\item{Options}{Object. The options to modify.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies the specified transit gateway.
When you modify a transit gateway, the modified options are applied to
new transit gateway attachments only. Your existing transit gateway
attachments are not modified.
}
\section{TransitGatewayId}{

The ID of the transit
gateway.
}

\section{Description}{

The description for the transit
gateway.
}

\section{Options}{

The options to
modify.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

