% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_reject_vpc_peering_connection}
\alias{ec2_reject_vpc_peering_connection}
\title{Reject Vpc Peering Connection}
\usage{
ec2_reject_vpc_peering_connection(
  VpcPeeringConnectionId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcPeeringConnectionId}{String. The ID of the VPC peering connection.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Rejects a VPC
peering connection request. The VPC peering connection must be in the
\code{pending-acceptance} state. Use the DescribeVpcPeeringConnections
request to view your outstanding VPC peering connection requests. To
delete an active VPC peering connection, or to delete a VPC peering
connection request that you initiated, use
DeleteVpcPeeringConnection.
}
\section{VpcPeeringConnectionId}{

The ID of the VPC peering
connection.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

