% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_reserved_instances}
\alias{ec2_describe_reserved_instances}
\title{Describe Reserved Instances}
\usage{
ec2_describe_reserved_instances(
  Filter = NULL,
  OfferingClass = NULL,
  ReservedInstancesId = NULL,
  DryRun = NULL,
  OfferingType = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{OfferingClass}{Character. Describes whether the Reserved Instance is Standard or Convertible.[optional]}

\item{ReservedInstancesId}{List.   One or more Reserved Instance IDs.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{OfferingType}{Character. The Reserved Instance offering type.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Reserved Instances
}
\section{Filter}{


One or more filters.
\itemize{
\item \code{availability-zone} - The Availability Zone where the Reserved
Instance can be used.
\item \code{duration} - The duration of the Reserved Instance (one year or
three years), in seconds (\code{31536000} \| \code{94608000}).
\item \code{end} - The time when the Reserved Instance expires (for example,
2015-08-07T11:54:42.000Z).
\item \code{fixed-price} - The purchase price of the Reserved Instance (for
example, 9800.0).
\item \code{instance-type} - The instance type that is covered by the
reservation.
\item \code{scope} - The scope of the Reserved Instance (\code{Region} or
\verb{Availability Zone}).
\item \code{product-description} - The Reserved Instance product platform
description. Instances that include \verb{(Amazon VPC)} in the product
platform description will only be displayed to EC2-Classic account
holders and are for use with Amazon VPC (\code{Linux/UNIX} \|
\verb{Linux/UNIX (Amazon VPC)} \| \verb{SUSE Linux} \|
\verb{SUSE Linux (Amazon VPC)} \| \verb{Red Hat Enterprise Linux} \|
\verb{Red Hat Enterprise Linux (Amazon VPC)} \| \code{Windows} \|
\verb{Windows (Amazon VPC)} \| \verb{Windows with SQL Server Standard} \|
\verb{Windows with SQL Server Standard (Amazon VPC)} \|
\verb{Windows with SQL Server Web} \|
\verb{Windows with SQL Server Web (Amazon VPC)} \|
\verb{Windows with SQL Server Enterprise} \|
\verb{Windows with SQL Server Enterprise (Amazon VPC)}).
\item \code{reserved-instances-id} - The ID of the Reserved Instance.
\item \code{start} - The time at which the Reserved Instance purchase request
was placed (for example, 2014-08-07T11:54:42.000Z).
\item \code{state} - The state of the Reserved Instance (\code{payment-pending} \|
\code{active} \| \code{payment-failed} \| \code{retired}).
\item \code{tag}:\ - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{usage-price} - The usage price of the Reserved Instance, per hour
(for example, 0.84).
}
}

\section{OfferingClass}{

Describes whether the Reserved Instance is Standard
or Convertible.
}

\section{ReservedInstancesId}{


One or more Reserved Instance IDs.

Default: Describes all your Reserved Instances, or only those otherwise
specified.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{OfferingType}{

The Reserved Instance
offering type. If you are using tools that predate the 2011-11-01 API
version, you only have access to the \verb{Medium Utilization} Reserved
Instance offering type.
}

