% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azure-clients.R
\name{api_graph_resource}
\alias{api_graph_resource}
\title{Microsoft Graph API Resource}
\description{
An R6 class that extends \link{api_resource} to provide specialized methods
for the Microsoft Graph API. This class adds convenience methods for
common Graph operations.
}
\keyword{internal}
\section{Super class}{
\code{\link[azr:api_resource]{azr::api_resource}} -> \code{api_graph_resource}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-api_graph_resource-me}{\code{api_graph_resource$me()}}
\item \href{#method-api_graph_resource-clone}{\code{api_graph_resource$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="azr" data-topic="api_resource" data-id="initialize"><a href='../../azr/html/api_resource.html#method-api_resource-initialize'><code>azr::api_resource$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_graph_resource-me"></a>}}
\if{latex}{\out{\hypertarget{method-api_graph_resource-me}{}}}
\subsection{Method \code{me()}}{
Fetch the current user's profile
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_graph_resource$me(select = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{select}}{A character vector of properties to select (e.g., c("displayName", "mail")).
If NULL, all properties are returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The response from the /me endpoint
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-api_graph_resource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-api_graph_resource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{api_graph_resource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
