% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_beast2_pkgs.R
\name{check_beast2_pkgs}
\alias{check_beast2_pkgs}
\title{Checks if \code{\link{bbt_run}} has the 'BEAST2' packages needed to process
its arguments. Will \link{stop} if not.}
\usage{
check_beast2_pkgs(mcmc, beast2_path = get_default_beast2_bin_path())
}
\arguments{
\item{mcmc}{the MCMC options,
see \link[beautier]{create_mcmc}}

\item{beast2_path}{name of either a 'BEAST2'  binary file
(usually simply \code{beast})
or a 'BEAST2'  jar file
(usually has a \code{.jar} extension).
Use \code{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \code{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\description{
For example, to use a Nested Sampling MCMC, the 'BEAST2' 'NS' package
needs to be installed.
}
\examples{
if (is_beast2_installed()) {
  # Minimal BEAST2 setup
  check_beast2_pkgs(mcmc = create_mcmc())

  # BEAST2 with NS package installed
  if (is_beast2_ns_pkg_installed()) {
    check_beast2_pkgs(mcmc = create_ns_mcmc())
  }
}
}
