% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.suggest.R
\name{backbone.suggest}
\alias{backbone.suggest}
\title{Suggest a backbone model}
\usage{
backbone.suggest(G, s = NULL)
}
\arguments{
\item{G}{graph: A graph object of class matrix, sparse \code{\link{Matrix}}, \code{\link{igraph}}, edgelist, or \code{\link{network}}.}

\item{s}{numeric: If provided, a backbone is extracted using this value as the significance level or sparsification parameter.}
}
\value{
If \code{s} == NULL: NULL, but a message is displayed with a suggested model.
If 0 <= \code{s} <= 1: A binary backbone graph in the same class as \code{G}, obtained by extracting the backbone
at the \code{s} significance level (if a statistical model is suggested) or using sparisfication parameter \code{s}
(if a sparsification model is suggested). The code used to perform the extraction, and suggested manuscript
text are displayed.
}
\description{
\code{backbone.suggest} suggests and optionally runs an appropriate backbone model for a graph object.
}
\examples{
M <- matrix(runif(100),10,10)  #A random weighted, directed graph
backbone <- backbone.suggest(M)
backbone <- backbone.suggest(M, s = 0.05)
}
