% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohortODX.R
\name{cohortODX}
\alias{cohortODX}
\title{Cohort-specific Overdiagnosis}
\usage{
cohortODX(
  object,
  data.clinical,
  data.assess,
  other.cause.rates = NULL,
  plot = TRUE
)
}
\arguments{
\item{object}{A 'baclava' object. The value object returned by \link{fit_baclava}().}

\item{data.clinical}{A data.frame object. The clinical data. The data must
 be structured as
 \itemize{
   \item \code{id}: A character, numeric, or integer object. The unique participant
     id to which the record pertains. Note these must include those provided in
     \code{data.assess}. Must be only 1 record for each participant.
   \item \code{age_entry}: A numeric object. The age at time of entry into the study.
     Note that this data is used to calculate a normalization; to expedite
     numerical integration, it is recommended that the ages be rounded.
     Optional input \code{round.age.entry} can be
     set to FALSE if this approximation is not desired; however, the
     computation time will significantly increase.
   \item \code{endpoint_type}: A character object. Must be one of \{"clinical",
     "censored", "preclinical"\}. Type "clinical" indicates that disease
     was diagnosed in the clinical compartment (i.e., symptomatic). Type
     "preclinical" indicates that disease was diagnosed in the preclinical
     compartment (i.e., during an assessment). Type
     "censored" indicates disease was not diagnosed prior to end of study.
   \item \code{age_endpoint}: A numeric object. The participant's age at the
     time the endpoint was evaluated.
}
If the sensitivity parameter (beta) is arm-specific, an additional
 column \code{arm} is required indicating the study arm to which each
 participant is assigned. Similarly, if the preclinical Weibull distribution is
 group-specific, an additional column \code{grp.rateP} is required. See Details
 for further information.
This input should be identical to that provided to obtain \code{object}.}

\item{data.assess}{A data.frame object. Disease status assessments recorded
 during healthy or preclinical compartment, e.g., screenings for disease.
 The data must be structured as
 \itemize{
   \item \code{id}: A character, numeric, or integer object. The unique participant
   id to which the record pertains. Multiple records for each id are allowed.
   \item \code{age_assess}: A numeric object. The participant's age at time of
   assessment.
   \item \code{disease_detected}: An integer object. Must be binary 0/1, where
   1 indicates that disease was detected at the assessment; 0 otherwise.
}
If the sensitivity parameter (beta) is screen-specific, an additional
 column \code{screen_type} is required indicating the type of each
 screen.
This input should be identical to that provided to obtain \code{object}.}

\item{other.cause.rates}{A data.frame object. Age specific incidence rates
that do not include the disease of interest. Must contain columns "Rate"
and "Age".}

\item{plot}{A logical object. If TRUE, generates a boxplot of the overdiagnosis
probability for each individual as a function of the screen at which
disease was detected. Includes only the consecutive screens for which more
than 1\% of the screen detected cases were detected.}
}
\value{
A list object. 
\itemize{
  \item \code{all} An n x S matrix containing the estimated overdiagnosis
    probability for each individual (n) and each posterior parameter set (S).
  \item \code{mean.individual} A vector containing the mean across S of
    the estimated overdiagnosis for each individual, i.e., \code{rowMeans(all)}.
  \item \code{mean.overall} A numeric, the mean overdiagnosis
    probability across all posterior parameter sets and screen-detected cases, 
    i.e., \code{mean(all)}. 
  \item \code{summary.by.screen} A matrix containing the summary statistics of 
    \code{mean.individual} for the individuals detected positive at
    each screen, i.e., \code{summary(mean.individual[diagnosis_screen_id == i])}. 
}
}
\description{
Estimates the overall and screening specific overdiagnosis probability
  for the cohort of the original analysis.
}
\examples{

data(screen_data)

theta_0 <- list("rate_H" = 7e-4, "shape_H" = 2.0,
                "rate_P" = 0.5  , "shape_P" = 1.0,
                "beta" = 0.9, psi = 0.4)
prior <- list("rate_H" = 0.01, "shape_H" = 1,
              "rate_P" = 0.01, "shape_P" = 1,
              "a_psi" = 1/2 , "b_psi" = 1/2,
              "a_beta" = 38.5, "b_beta" = 5.8)

# This is for illustration only -- the number of Gibbs samples should be
# significantly larger and the epsilon values should be tuned.
example <- fit_baclava(data.assess = data.screen,
                       data.clinical = data.clinical,
                       t0 = 30.0,
                       theta_0 = theta_0,
                       prior = prior,
                       save.latent = TRUE)

# if rates are not available, an all cause dataset is provided in the package
# NOTE: these predictions will be over-estimated

data(all_cause_rates)
all_cause_rates <- all_cause_rates[, c("Age", "both")]
colnames(all_cause_rates) <- c("Age", "Rate")

cohort_odx <- cohortODX(object = example,
                        data.clinical = data.clinical,
                        data.assess = data.screen,
                        other.cause.rates = all_cause_rates,
                        plot = FALSE)

}
