% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-constructors.R
\name{mod_norm}
\alias{mod_norm}
\title{Specify a Normal Model}
\usage{
mod_norm(formula, data, weights)
}
\arguments{
\item{formula}{An R \link[stats:formula]{formula},
specifying the outcome and predictors.}

\item{data}{A data frame containing outcome,
predictor, and, optionally, weights variables.}

\item{weights}{Name of the weights variable,
a \code{1}, or a formula. See below for details.}
}
\value{
An object of class \code{bage_mod_norm}.
}
\description{
Specify a model where the outcome is drawn from
a normal distribution.
}
\details{
The model is hierarchical. The means in the normal distribution
are described by a prior model formed from dimensions such
as age, sex, and time. The terms for these dimension themselves
have models, as described in \link{priors}. These priors all have defaults,
which depend on the type of term (eg an intercept, an age main effect,
or an age-time interaction.)

Internally, the outcome
variable scaled to have mean 0 and sd 1.
}
\section{Mathematical details}{


The likelihood is

\deqn{y_i \sim \text{N}(\mu_i, \xi^2 / w_i)}

where
\itemize{
\item \eqn{y_i} is a scaled value for an, such of the log of income, for some
combination \eqn{i} of classifying variables,
such as age, sex, and region;
\item \eqn{\mu_i} is a mean;
\item \eqn{\xi} is a standard deviation parameter; and
\item \eqn{w_i} is a weight.
}

The scaling of the outcome variable is done internally.
If \eqn{y_i^*} is the original, then \eqn{y_i = (y_i^* - m)/s}
where \eqn{m} and \eqn{s} are the sample mean and standard
deviation of \eqn{y_i^*}.

In some applications, \eqn{w_i} is set to 1
for all \eqn{i}.

The means \eqn{\mu_i} equal the sum of terms formed
from classifying variables,

\deqn{\mu_i = \sum_{m=0}^{M} \beta_{j_i^m}^{(m)}}

where
\itemize{
\item \eqn{\beta^{0}} is an intercept;
\item \eqn{\beta^{(m)}}, \eqn{m = 1, \dots, M}, is a main effect
or interaction; and
\item \eqn{j_i^m} is the element of \eqn{\beta^{(m)}} associated with
cell \eqn{i}.
}

The \eqn{\beta^{(m)}} are given priors, as described in \link{priors}.

The prior for \eqn{\xi} is described in \code{\link[=set_disp]{set_disp()}}.
}

\section{Specifying weights}{


The \code{weights} argument can take three forms:
\itemize{
\item the name of a variable in \code{data}, with or without
quote marks, eg \code{"wt"} or \code{wt};
\item the number \code{1}, in which no weights are used; or
\item a formula, which is evaluated with \code{data} as its
environment (see below for example).
}
}

\examples{
mod <- mod_norm(value ~ diag:age + year,
                data = nld_expenditure,
                weights = 1)

## use formula to specify weights
mod <- mod_norm(value ~ diag:age + year,
                data = nld_expenditure,
                weights = ~sqrt(value))
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}} Specify Poisson model
\item \code{\link[=mod_binom]{mod_binom()}} Specify binomial model
\item \code{\link[=set_prior]{set_prior()}} Specify non-default prior for term
\item \code{\link[=set_disp]{set_disp()}} Specify non-default prior for standard deviation
\item \code{\link[=fit]{fit()}} Fit a model
\item \code{\link[=forecast]{forecast()}} Forecast a model
\item \code{\link[=report_sim]{report_sim()}} Do a simulation study on a model
}
}
