% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mopt.R
\name{mopt}
\alias{mopt}
\title{Estimation of the optimal subsample size for bagged CV}
\usage{
mopt(x, N, r = 1000, s = 100, ncores = parallel::detectCores())
}
\arguments{
\item{x}{Vector. Sample.}

\item{N}{Positive integer. Number of subsamples for the bagged bandwidth.}

\item{r}{Positive integer. Size of the subsamples.}

\item{s}{Positive integer. Number of subsamples.}

\item{ncores}{Positive integer. Number of cores with which to parallelize the computations.}
}
\value{
Estimate of the optimal subsample size.
}
\description{
Estimation of the optimal subsample size for bagged CV
}
\details{
Estimates the optimal size of the subsamples for the bagged CV bandwidth selector.
}
\examples{
set.seed(1)
x <- rt(10^5, 5)
mopt(x, 500, 500, 10, 2)

}
