% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_dist.R
\name{priors}
\alias{priors}
\alias{multinormal}
\alias{lkj}
\alias{normal}
\alias{lognormal}
\alias{student_t}
\alias{cauchy}
\alias{uniform}
\title{Prior distributions in baggr}
\usage{
multinormal(location, Sigma)

lkj(shape, order = NULL)

normal(location, scale)

lognormal(mu, sigma)

student_t(nu, mu, sigma)

cauchy(location, scale)

uniform(lower, upper)
}
\arguments{
\item{location}{Mean for normal and multivariate normal (in which case \code{location} is a vector),
and median for Cauchy distributions}

\item{Sigma}{Variance-covariance matrix for multivariate normal.}

\item{shape}{Shape parameter for LKJ}

\item{order}{Order of LKJ matrix (typically it does not need to be specified,
as it is inferred directly in the model)}

\item{scale}{SD for Normal, scale for Cauchy}

\item{mu}{mean of ln(X) for lognormal or location for Student's generalised T}

\item{sigma}{SD of ln(X) for lognormal or scale for Student's generalised T}

\item{nu}{degrees of freedom for Student's generalised T}

\item{lower}{Lower bound for Uniform}

\item{upper}{Upper bound for Uniform}
}
\description{
This page provides a list of all available distributions
that can be used to specify priors in \code{\link[=baggr]{baggr()}}. These convenience functions
are designed to allow the user to write the priors in the most "natural" way when
implementing them in baggr. Apart from
passing on the arguments, their only other role is to perform a rudimentary check
if the distribution is specified correctly.
}
\details{
The prior choice in \link{baggr} is done via distinct arguments for each type of prior,
e.g. \code{prior_hypermean}, or a named list of several passed to \code{prior}.
See the examples below.

Notation for priors is "plain-text", in that you can write the distributions as
\code{normal(5,10)}, \code{uniform(0,100)} etc.

Different parameters admit different priors (see \link{baggr} for explanations of
what the different \code{prior_} arguments do):
\itemize{
\item \code{prior_hypermean}, \code{prior_control}, and \code{prior_beta}
will take \code{"normal"}, \code{"uniform"}, \code{"lognormal"}, and
\code{"cauchy"} input for scalars.
For a vector hypermean (see \code{"mutau"} model), it will take any of these
arguments and apply them independently to
each component of the vector, or it can also take a \code{"multinormal"} argument
(see the example below).
\item \code{prior_hypersd}, \code{prior_control_sd}, and \code{prior_sigma} will take \code{"normal"}, \code{"uniform"}, and \code{"lognormal"}
but negative parts of the distribution are truncated
\item \code{prior_hypercor} allows \code{"lkj"} input (see Lewandowski \emph{et al.})
}
}
\examples{
# (these are not the recommended priors -- for syntax illustration only)

# change the priors for 8 schools:
baggr(schools, model = "rubin", pooling = "partial",
      prior_hypermean = normal(5,5),
      prior_hypersd = normal(0,20))

\donttest{
# passing priors as a list
custom_priors <- list(hypercor = lkj(1), hypersd = normal(0,10),
                      hypermean = multinormal(c(0,0),matrix(c(10,3,3,10),2,2)))
microcredit_summary_data <- prepare_ma(microcredit, outcome = "consumption")
baggr(microcredit_summary_data, model = "mutau",
      pooling = "partial", prior = custom_priors)
}
}
\references{
Lewandowski, Daniel, Dorota Kurowicka, and Harry Joe.
"Generating Random Correlation Matrices Based on Vines and Extended Onion Method."
\emph{Journal of Multivariate Analysis} 100, no. 9 (October 1, 2009): 1989-2001.
}
\author{
Witold Wiecek, Rachael Meager
}
