% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models2pam.R
\name{models2pam}
\alias{models2pam}
\title{models2pam: Converts binary rasters to a PAM}
\usage{
models2pam(
  mods_stack,
  return_coords = FALSE,
  sparse = TRUE,
  parallel = FALSE,
  ncores = 2
)
}
\arguments{
\item{mods_stack}{A raster stack containing binary models of each
species in the community.}

\item{return_coords}{Logical. If TRUE the pam will be returned with
coordinates in the first two columns.}

\item{sparse}{Logical. If TRUE the PAM will be returned as a sparse matrix.}

\item{parallel}{Logical. If TRUE computations will be done in parallel}

\item{ncores}{Integer. Number of cores to run the parallel process.}
}
\value{
A presence-absence matrix (PAM).
}
\description{
Function to convert binary raster models to a
Presence Absences Matrix.
}
\details{
For more information about PAM see Soberon and Cavner (2015).
}
\examples{
\donttest{
lagos_path <- system.file("extdata/conejos",
                          package = "bamm")
enm_path <- list.files(lagos_path,
                       pattern = ".tif",
                       full.names = TRUE)[1:10]
en_models <- raster::stack(enm_path) >0.01
pam <- bamm::models2pam(en_models,
                        return_coords=TRUE,
                        sparse=FALSE,
                        parallel=FALSE,ncores=1)
head(pam)
}
}
\references{
\insertRef{Soberon2015}{bamm}.
}
\author{
Luis Osorio-Olvera & Jorge Soberón
}
