% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pol2pam.R
\name{pol2pam}
\alias{pol2pam}
\title{Convert distribution polygons to a presence-absence matrix (PAM)}
\usage{
pol2pam(poly, taxon_attribute, resolution, polymask = NULL)
}
\arguments{
\item{poly}{Spatial polygon object (SpatialPolygonsDataFrame, sf, etc.) containing
species or taxon distribution data.}

\item{taxon_attribute}{Character. The name of the column in `poly` that contains
taxon identifiers (species, genera, etc.).}

\item{resolution}{Numeric. The resolution for the output raster in coordinate
system units (cell size).}

\item{polymask}{Optional. A spatial polygon object used to mask and crop the
resulting raster. If NULL, no masking is applied.}
}
\value{
A PAM (Presence-Absence Matrix) object of class `pam` from the `bamm`
  package containing:
  \itemize{
    \item \code{matrix}: Presence-absence matrix (1/0) where rows represent grid cells
          and columns represent taxa
    \item \code{richness}: Richness pattern across grid cells
    \item \code{sparse}: Logical indicating if the matrix is stored in sparse format
    \item \code{cell_coordinates}: Coordinates of each grid cell
  }
}
\description{
This function takes spatial polygon objects (typically species distribution polygons)
and converts them into a presence-absence matrix (PAM) using a rasterization approach
at a specified resolution. The function is particularly useful for biodiversity
and biogeography analyses.
}
\details{
The function works by:
\enumerate{
  \item Creating a base raster with the specified resolution and extent
  \item Splitting polygons by taxon attribute
  \item Rasterizing each taxon's distribution using exact extraction
  \item Stacking individual rasters into a multi-layer raster
  \item Applying optional masking with polymask
  \item Converting the raster stack to a PAM using bamm::models2pam
}
}
\note{
This function requires the following packages: raster, exactextractr, purrr, and bamm.
The input polygons are converted to SpatialPolygonsDataFrame if they aren't already.
}
\examples{
\dontrun{
# Load required libraries
library(raster)

# Example with sample data
uicn <- readRDS(system.file("extdata/uicn.rds",package = "bamm"))
sudam <- readRDS(system.file("extdata/suam.rds",package = "bamm"))
# Convert to PAM with 0.5 degree resolution
pam_result <- bamm::pol2pam(poly = uicn,
                            taxon_attribute = "binomial",
                            resolution = 0.5,
                            polymask = NULL)

# With masking polygon
pam_masked <- pol2pam(poly = uicn,
                      taxon_attribute = "binomial",
                      resolution = 0.5,
                      polymask = sudam)
}

}
\seealso{
\code{\link[bamm]{models2pam}}, \code{\link[raster]{raster}},
\code{\link[exactextractr]{exact_extract}}
}
