% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-joensson.R
\encoding{UTF-8}
\name{model.joensson.apply}
\alias{model.joensson.apply}
\title{Use the Jönnson model}
\arguments{
\item{...}{See \code{\link[=phenology]{phenology()}} for a detailled description of the function.}

\item{tmean, tmax}{Daily mean/maximum temperatures in °C.}

\item{daylength}{Length of the day in hours. Can be created with
\code{\link[=create_daylength_rst]{create_daylength_rst()}} or \code{\link[=create_daylength_rst]{create_daylength_rst()}}.}

\item{mode}{Can be \code{'fast'} (default) or \code{'slow'}. Determines if the lower
(\code{'fast'}) or upper (\code{'slow'}) limit for the development of  genertion
should be used.}
}
\value{
The function returns a phenology. Look \link[=analyse.phenology]{here} to find out how it can be analysed.
}
\description{
This page describes the usage of the the Jönsson model with \code{\link[=phenology]{phenology()}}.
The model specific inputs are listed and its basic functionality is explained.
The Jönsson model was published by \insertCite{Jonsson2011;textual}{barrks} and
parametrized for \emph{Ips typographus} in southern Sweden.
}
\details{
In \code{barrks}, \code{\link[=phenology]{phenology()}} is used to apply a model. The following code
illustrates which inputs are required to apply the Jönsson model and which additional
parameters are available.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{phenology("joensson", ..., tmean, tmax, daylength, mode = 'fast')

# calculate submodels separately
phenology("joensson", ..., .submodels = 'onset', tmax)
phenology("joensson", ..., .submodels = 'diapause', tmax, daylength)
phenology("joensson", ..., .submodels = 'development',
          .onset, .diapause = NULL, .mortality = NULL,
          tmean, mode = 'fast')
}\if{html}{\out{</div>}}
}
\section{Functioning}{


In the following, the basic functioning of the Jönsson model is explained.
\itemize{
\item \strong{Onset}: The onset of swarming is triggerd when the degree days of the maximum temperature reach
a specific threshold and the maximum temperature exceeds the minimum flight temperature.
The onset of infestation is triggered seven days later to account
for a pre-oviposition period.
\item \strong{Development}: The development progresses proportional to the degree days
of the mean temperature. To account for varying sun exposures, two different
thermal thresholds are defined that reflect the lower and the upper limit
of development. A generations starts swarming when it has finished its
development and the maximum temperature exceeds the minimum flight temperature.
Seven days later, the development of a new generation starts.
\item \strong{Diapause}: The diapause is initiated when the daylength falls below a
threshold. It is recommended to adjust the daylength threshold when applying elsewhere
(e.g. values from literature). \insertCite{Jonsson2011;textual}{barrks} proposes a model to
calculate the daylength threshold based on long-term climate data.
\item \strong{Mortality}: The Jönsson model does not have a mortality submodel implemented.
}

Look \link[=model.joensson.customize]{here} to find out how the model parameters affect the actual calculations and which values are used by default.
}

\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.joensson.customize}}

Other phenology applications: 
\code{\link{model.bso.apply}},
\code{\link{model.chapy.apply}},
\code{\link{model.lange.apply}},
\code{\link{model.phenips.apply}},
\code{\link{model.phenips_clim.apply}},
\code{\link{model.rity.apply}}
}
\concept{phenology applications}
