% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{barrks_data}
\alias{barrks_data}
\title{Load sample data}
\source{
\itemize{
\item \href{https://opendata.dwd.de/climate_environment/CDC/grids_germany/daily/hyras_de/}{https://opendata.dwd.de/climate_environment/CDC/grids_germany/daily/hyras_de/}
\item \href{https://opendata.dwd.de/climate_environment/CDC/observations_germany/climate/daily/kl/historical/}{https://opendata.dwd.de/climate_environment/CDC/observations_germany/climate/daily/kl/historical/}
\item \href{https://opendata.dwd.de/climate_environment/CDC/observations_germany/climate/daily/solar/}{https://opendata.dwd.de/climate_environment/CDC/observations_germany/climate/daily/solar/}
}
}
\usage{
barrks_data(dataset = "raster")
}
\arguments{
\item{dataset}{Choose the data set that should be returned.}
}
\value{
The respective data set. Can be a list of SpatRasters (for
\code{dataset = 'raster'}) or a data frame.
}
\description{
The package comes with sample data that allow the application of all models
available. The following data sets are available:
}
\details{
\itemize{
\item \code{raster} Contains a list of raster weather datasets for a sample area.
The data was taken from Deutscher Wetterdienst (DWD).
\item \code{stations} Contains sample station weather data for some cities in Germany.
The data was taken from Deutscher Wetterdienst (DWD).
Missing global radiation values were replaced by the mean value of the other stations.
\item \code{station_coords} Contains the coordinates (longitude/latitude) of the
stations that are included in the \code{stations} data set.
The data was taken from Deutscher Wetterdienst (DWD).
}
}
\examples{
\donttest{
# plot first layer of the minimum temperature of the sample raster data
terra::plot(barrks_data()$tmin[[1]])

# print the first lines of the sample station data
head(barrks_data('stations'), 10)

# print the coordinates of the sample stations
barrks_data('station_coords')
}
}
