/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import bartMachine.StatToolbox;
import bartMachine.bartMachineTreeNode;
import bartMachine.bartMachine_g_mh;
import java.io.Serializable;
import java.util.Arrays;

public abstract class bartMachine_h_eval
extends bartMachine_g_mh
implements Serializable {
    @Override
    public double Evaluate(double[] dArray, int n) {
        return this.EvaluateViaSampAvg(dArray, n);
    }

    public double EvaluateViaSampAvg(double[] dArray, int n) {
        return StatToolbox.sample_average(this.getGibbsSamplesForPrediction(dArray, n));
    }

    public double EvaluateViaSampMed(double[] dArray, int n) {
        return StatToolbox.sample_median(this.getGibbsSamplesForPrediction(dArray, n));
    }

    protected double[] getGibbsSamplesForPrediction(double[] dArray, int n) {
        double[] dArray2 = new double[this.numSamplesAfterBurningAndThinning()];
        for (int i = 0; i < this.numSamplesAfterBurningAndThinning(); ++i) {
            bartMachineTreeNode[] bartMachineTreeNodeArray = this.gibbs_samples_of_bart_trees_after_burn_in[i];
            double d = 0.0;
            for (bartMachineTreeNode bartMachineTreeNode2 : bartMachineTreeNodeArray) {
                d += bartMachineTreeNode2.Evaluate(dArray);
            }
            dArray2[i] = this.un_transform_y(d);
        }
        return dArray2;
    }

    protected double[] getPostPredictiveIntervalForPrediction(double[] dArray, double d, int n) {
        double[] dArray2 = this.getGibbsSamplesForPrediction(dArray, n);
        Arrays.sort(dArray2);
        int n2 = (int)Math.round((1.0 - d) / 2.0 * (double)dArray2.length) - 1;
        int n3 = (int)Math.round(((1.0 - d) / 2.0 + d) * (double)dArray2.length) - 1;
        double[] dArray3 = new double[]{dArray2[n2], dArray2[n3]};
        return dArray3;
    }

    protected double[] get95PctPostPredictiveIntervalForPrediction(double[] dArray, int n) {
        return this.getPostPredictiveIntervalForPrediction(dArray, 0.95, n);
    }
}

