% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.bartcs}
\alias{plot.bartcs}
\title{Draw plot for \code{bartcs} object}
\usage{
\method{plot}{bartcs}(x, method = NULL, parameter = NULL, ...)
}
\arguments{
\item{x}{A \code{bartcs} object.}

\item{method}{"\code{pip}" for posterior inclusion probability plot
or "\code{trace}" for trace plot.}

\item{parameter}{Target of parameter for traceplot.}

\item{...}{Additional arguments for pip plot.
Check \code{?ggcharts::bar_chart} for possible arguments.}
}
\value{
A \code{ggplot} object of either pip plot or trace plot.
}
\description{
Two options are available:
posterior inclusion probability (pip) plot and trace plot.
}
\details{
\subsection{PIP plot}{

When a posterior sample is sampled during training,
\code{sbart()} or \code{mbart()} also counts
which variables are included in the model and
compute pip for each variable.
For \code{bartcs} object \code{x},
this is stored in \code{x$var_count} and \code{x$var_prob} respectively.
\code{plot(method = "pip")} uses this information and
draws plot using \code{ggcharts::bar_chart()}.
}

\subsection{Traceplot}{

Parameters are recorded for each MCMC iterations.
Parameters include "\code{ATE}", "\code{Y1}", "\code{Y0}", "\code{dir_alpha}",
and either "\code{sigma2_out}" from \code{mbart()}
or "\code{sigma2_out1}" and "\code{sigma2_out0}" from \code{sbart()}.
Vertical line indicates burn-in.
}
}
\examples{
data(ihdp, package = "bartcs")
x <- mbart(
  Y               = ihdp$y_factual,
  trt             = ihdp$treatment,
  X               = ihdp[, 6:30],
  num_tree        = 10,
  num_chain       = 2,
  num_post_sample = 20,
  num_burn_in     = 10,
  verbose         = FALSE
)

# pip plot
plot(x, method = "pip")
plot(x, method = "pip", top_n = 10)
plot(x, method = "pip", threshold = 0.5)
# Check `?ggcharts::bar_chart` for other possible arguments.

# trace plot
plot(x, method = "trace")
plot(x, method = "trace", "Y1")
plot(x, method = "trace", "dir_alpha")

}
