% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base64.R
\name{img}
\alias{img}
\title{Encode a png file as a img data uri}
\usage{
img(file, Rd = FALSE, alt = "image")
}
\arguments{
\item{file}{png file to translate into a data uri}

\item{Rd}{if \code{TRUE}, extra markup is added to facilitate inclusion
of the image in an Rd file}

\item{alt}{alternate text}
}
\description{
This creates html code to embed a png file into an html document.
\if{html}{\Sexpr[results=rd, stage=build, echo=FALSE]{
  pngfile <- tempfile()
  png(pngfile, width = 600, height = 400 )
  plot(1:100, rnorm(100), pch = 21, bg = "red", cex = 2 )
  dev.off()
  base64::img( pngfile, Rd = TRUE )
}}
}
\examples{
pngfile <- tempfile()
png(pngfile, width = 600, height = 400)
plot(1:100, rnorm(100), pch = 21, bg = "red", cex = 2 )
dev.off()
img(pngfile, Rd = TRUE)
}
