% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/battingStats.R
\name{wRC}
\alias{wRC}
\title{Batting: Calculate Weighted Runs Created (wRC)}
\usage{
wRC(BattingTable = NULL, PitchingTable = NULL, FieldingTable = NULL,
  Fangraphs = FALSE, NA_to_zero = TRUE, Sep.Leagues = FALSE)
}
\arguments{
\item{BattingTable}{A full batting table from the \code{Lahman} package or the Chadwick Bureau GitHub repository.
Any subsetting or removal of players will affect your results. All players for each year are recommended.}

\item{PitchingTable}{A full pitching table from the \code{Lahman} package or the Chadwick Bureau GitHub repository.
Any subsetting or removal of players will affect your results. All players for each year are recommended.}

\item{FieldingTable}{A full fielding table from the \code{Lahman} package or the Chadwick Bureau GitHub repository.
Any subsetting or removal of players will affect your results. All players for each year are recommended.}

\item{Fangraphs}{If TRUE the function will download wOBA values from Fangraphs. Both wOBA scale and league wOBA are used in the wRC
calculation. If FALSE the function will use the internal wOBA algorithm, which is adapted from Tom Tango's original wOBA formula.
This algorithm produces a slightly different wOBA scale than the Fangraphs wOBA scale, so variations in wRC should be expected.
The default internal method does not require an external download from Fangraphs. If not specified, the default is set to FALSE.}

\item{NA_to_zero}{If TRUE this will replace NAs with 0 for years that certain stats were not counted. For example, sacrifice hits
were not a counted statistic until 1954, therefore we are technically unable to calculate wRC for any player prior to 1954.
The default is set to TRUE. Even though this is bad practice mathematically, many in the sabermetrics community accept the practice.
If FALSE, the wRC calculation will return NaN for years with missing data.}

\item{Sep.Leagues}{If TRUE the algorithm will calculate different run environments for the National and American leagues. Grouping
the leagues can solve problems introduced by the designated hitter and hitting pitchers. It also serves to further isolate for
park factors between the American and National leagues. The default for this argument is FALSE.}
}
\description{
Find the wRC for all players with one or more hits for a particular season.
Required fields from the batting table are "AB", "H", "BB", "X2B", "X3B", "HR", "HBP", "SF", "IBB."
}
\examples{

data("Batting2016")
head(Batting2016)
data("Pitching2016")
head(Pitching2016)
data("Fielding2016")
head(Fielding2016)

Batting2016$wRC <- wRC(Batting2016, Pitching2016, Fielding2016, Fangraphs=FALSE,
                         NA_to_zero=TRUE, Sep.Leagues=FALSE)

}
\seealso{
Other Batting functions: \code{\link{BABIP}},
  \code{\link{BA}}, \code{\link{BBpct}},
  \code{\link{CTpct}}, \code{\link{HRpct}},
  \code{\link{ISO}}, \code{\link{Kpct}}, \code{\link{OBP}},
  \code{\link{OPS}}, \code{\link{PA}},
  \code{\link{RC2002}}, \code{\link{RCbasic}},
  \code{\link{RCtech}}, \code{\link{SLG}},
  \code{\link{TBs}}, \code{\link{XBHpct}},
  \code{\link{XBperH}}, \code{\link{wOBA}},
  \code{\link{wRAA}}
}
\keyword{Above}
\keyword{Average}
\keyword{Runs}
\keyword{Weighted}
\keyword{wRC}
