% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_game_pks.R
\name{mlb_game_pks}
\alias{mlb_game_pks}
\title{\strong{Get MLB Game Info by Date and Level}}
\usage{
mlb_game_pks(date, level_ids = c(1))
}
\arguments{
\item{date}{The date for which you want to find game_pk values for MLB games}

\item{level_ids}{A numeric vector with ids for each level where game_pks are
desired. See below for a reference of level ids.}
}
\value{
Returns a tibble that includes game_pk values and additional
information for games scheduled or played with the following columns:\tabular{ll}{
   col_name \tab types \cr
   game_pk \tab integer \cr
   link \tab character \cr
   gameType \tab character \cr
   season \tab character \cr
   gameDate \tab character \cr
   officialDate \tab character \cr
   isTie \tab logical \cr
   gameNumber \tab integer \cr
   publicFacing \tab logical \cr
   doubleHeader \tab character \cr
   gamedayType \tab character \cr
   tiebreaker \tab character \cr
   calendarEventID \tab character \cr
   seasonDisplay \tab character \cr
   dayNight \tab character \cr
   scheduledInnings \tab integer \cr
   reverseHomeAwayStatus \tab logical \cr
   inningBreakLength \tab integer \cr
   gamesInSeries \tab integer \cr
   seriesGameNumber \tab integer \cr
   seriesDescription \tab character \cr
   recordSource \tab character \cr
   ifNecessary \tab character \cr
   ifNecessaryDescription \tab character \cr
   status.abstractGameState \tab character \cr
   status.codedGameState \tab character \cr
   status.detailedState \tab character \cr
   status.statusCode \tab character \cr
   status.startTimeTBD \tab logical \cr
   status.abstractGameCode \tab character \cr
   teams.away.score \tab integer \cr
   teams.away.isWinner \tab logical \cr
   teams.away.splitSquad \tab logical \cr
   teams.away.seriesNumber \tab integer \cr
   teams.away.leagueRecord.wins \tab integer \cr
   teams.away.leagueRecord.losses \tab integer \cr
   teams.away.leagueRecord.pct \tab character \cr
   teams.away.team.id \tab integer \cr
   teams.away.team.name \tab character \cr
   teams.away.team.link \tab character \cr
   teams.home.score \tab integer \cr
   teams.home.isWinner \tab logical \cr
   teams.home.splitSquad \tab logical \cr
   teams.home.seriesNumber \tab integer \cr
   teams.home.leagueRecord.wins \tab integer \cr
   teams.home.leagueRecord.losses \tab integer \cr
   teams.home.leagueRecord.pct \tab character \cr
   teams.home.team.id \tab integer \cr
   teams.home.team.name \tab character \cr
   teams.home.team.link \tab character \cr
   venue.id \tab integer \cr
   venue.name \tab character \cr
   venue.link \tab character \cr
   content.link \tab character \cr
}
}
\description{
Find game_pk values for professional baseball games (major and minor leagues)
via the MLB api \url{https://www.mlb.com/}
}
\details{
Level IDs:

The following IDs can be passed to the level_ids argument:

1 = MLB
11 = Triple-A
12 = Doubl-A
13 = Class A Advanced
14 = Class A
15 = Class A Short Season
5442 = Rookie Advanced
16 = Rookie
17 = Winter League
}
\examples{
\donttest{
  try(mlb_game_pks("2019-04-29"))
}
}
