% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_dummy_regressor.R
\name{predict_dummy_regressor}
\alias{predict_dummy_regressor}
\title{dummy regressor predictor}
\usage{
predict_dummy_regressor(object, X)
}
\arguments{
\item{object}{a list from the dummy_regressor function}

\item{X}{a data frame}
}
\value{
the predicted values
}
\description{
dummy regressor predictor
}
\examples{
#' # Split the data into training and testing sets
set.seed(2023)
index <- sample(1:nrow(iris), nrow(iris) * 0.8)
train_data <- iris[index,]
test_data <- iris[-index,]

# Make predictions using the trained dummy regressor
reg_model <- dummy_regressor(train_data$Sepal.Length, strategy = "median")
y_hat <- predict_dummy_regressor(reg_model, test_data)
# Find mean squared error
mean((test_data$Sepal.Length-y_hat)^2)
}
