% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_new_database.R
\name{extract_base_rate_items}
\alias{extract_base_rate_items}
\title{Create base-rate items from groups x descriptions typicality matrix}
\usage{
extract_base_rate_items(typicality_matrix)
}
\arguments{
\item{typicality_matrix}{A numeric matrix or data frame where rows are groups
and columns are descriptions. If a data frame, the first column is assumed to contain
the group names.}
}
\value{
A data frame with the following columns:
\describe{
\item{Group1}{The group with the higher typicality score for the description.}
\item{Group2}{The group with the lower typicality score.}
\item{Description}{The description (e.g., adjective) being compared.}
\item{Score1}{The typicality score for Group1.}
\item{Score2}{The typicality score for Group2.}
\item{StereotypeStrength}{The log-ratio: \code{log(Score1 / Score2)}. Always >= 0.}
}
}
\description{
This function processes a typicality matrix to identify base-rate items
by comparing typicality scores of descriptions between all unique pairs of groups.
}
\details{
For each pair of groups and each description (e.g., adjective), it identifies which group
received the higher typicality score. The output includes the names of both groups, their scores,
and the log-ratio between the higher and lower score.

It can be quite slow for large matrices, as the number of items becomes very large.

By construction, the returned \code{Group1} always has a higher or equal typicality score
than \code{Group2} for a given description. This ensures that the resulting \code{StereotypeStrength}
(defined as \code{log(Score1 / Score2)}) is always \strong{positive or zero}, and represents the strength
of the stereotypical association in favor of \code{Group1}.
}
\examples{
mat <- matrix(runif(9, 1, 100), nrow = 3,
              dimnames = list(c("GroupA", "GroupB", "GroupC"),
                              c("smart", "brave", "greedy")))
extract_base_rate_items(mat)
}
