% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd.R
\name{ecd}
\alias{ecd}
\alias{ecd,OneStageBasket-method}
\alias{ecd,TwoStageBasket-method}
\title{Expected number of correct decisions}
\usage{
ecd(design, ...)

\S4method{ecd}{OneStageBasket}(
  design,
  p1 = NULL,
  n,
  lambda,
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  ...
)

\S4method{ecd}{TwoStageBasket}(
  design,
  p1 = NULL,
  n,
  n1,
  lambda,
  interim_fun,
  interim_params = list(),
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{p1}{Probabilities under the alternative hypothesis. If
\code{length(p1) ==  1}, then this is a common probability for all
baskets.}

\item{n}{The sample size per basket.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{weight_fun}{Which function should be used to calculate the pairwise
weights.}

\item{weight_params}{A list of tuning parameters specific to
\code{weight_fun}.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}

\item{interim_fun}{Which type of interim analysis should be conducted
in case of a two-stage design.}

\item{interim_params}{A list of tuning parameters specific to
\code{interim_fun}.}
}
\value{
A numeric value.
}
\description{
Computes the expected number of correct decisions of a basket trial.
}
\details{
Computes the expected number of correction decisions, i.e. the
expected number of actually active baskets that are declared active and
actually inactive baskets that are declared inactive.
}
\section{Methods (by class)}{
\itemize{
\item \code{ecd(OneStageBasket)}: Expected number of correction decisions for a single-stage
basket design.

\item \code{ecd(TwoStageBasket)}: Expected number of correction decisions for a two-stage
basket design.

}}
\examples{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
ecd(design = design, p1 = c(0.5, 0.2, 0.2), n = 20, lambda = 0.99,
weight_fun = weights_fujikawa)
}
