% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow.R
\name{pow}
\alias{pow}
\alias{pow,OneStageBasket-method}
\alias{pow,TwoStageBasket-method}
\title{Power}
\usage{
pow(design, ...)

\S4method{pow}{OneStageBasket}(
  design,
  p1,
  n,
  lambda,
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  results = c("ewp", "group"),
  ...
)

\S4method{pow}{TwoStageBasket}(
  design,
  p1,
  n,
  n1,
  lambda,
  interim_fun,
  interim_params = list(),
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  results = c("ewp", "group"),
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{p1}{Probabilities under the alternative hypothesis. If
\code{length(p1) ==  1}, then this is a common probability for all
baskets.}

\item{n}{The sample size per basket.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{weight_fun}{Which function should be used to calculate the pairwise
weights.}

\item{weight_params}{A list of tuning parameters specific to
\code{weight_fun}.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{results}{Whether only the experimentwise power (option \code{ewp})
or also the rejection probabilities per group (option \code{group}) should
be returned.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}

\item{interim_fun}{Which type of interim analysis should be conducted
in case of a two-stage design.}

\item{interim_params}{A list of tuning parameters specific to
\code{interim_fun}.}
}
\value{
If \code{results = "ewp"} then the experimentwise power is
returned as a numeric value. If \code{results = "group"} then a list with
the rejection probabilities per group and the experimentwise power
is returned. For baskets with p1 = p0 the rejection probabilities
corresponds to the type 1 error rate, for baskets with p1 > p0 the
rejection probabilities corresponds to the power.
}
\description{
Computes the exact power for a basket trial.
}
\details{
\code{pow} computes the exact experimentwise power and the
exact rejection probabilities per group. The experimentwise power
is the probability to reject at least one null hypothesis for a basket with
p1 > p0. The rejection probabilities correspond to the type 1 error
rate for baskets with p1 = p0 and to the power for baskets with
p1 > p0.

If \code{prune = TRUE} then the baskets with an observed number of baskets
smaller than the pooled critical value are not borrowed from. The
pooled critical value is the smallest integer c for which all null
hypotheses can be rejected if the number of responses is exactly c for
all baskets.

This method is implemented for the class \code{\link{OneStageBasket}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{pow(OneStageBasket)}: Power for a single-stage basket design.

\item \code{pow(TwoStageBasket)}: Power for a two-stage basket design.

}}
\examples{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
pow(design, p1 = c(0.2, 0.5, 0.5), n = 15, lambda = 0.99,
  weight_fun = weights_fujikawa, weight_params = list(epsilon = 2, tau = 0))
}
