% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateBatchData.R
\name{generateBatchData}
\alias{generateBatchData}
\title{Generate batch data}
\usage{
generateBatchData(
  N,
  P,
  group_means,
  group_std_devs,
  batch_shift,
  batch_scale,
  group_weights,
  batch_weights,
  type = "MVN",
  group_dfs = NULL,
  frac_known = 0.2,
  permute_variables = TRUE,
  scale_data = FALSE
)
}
\arguments{
\item{N}{The number of items (rows) to generate.}

\item{P}{The number of columns in the generated dataset.}

\item{group_means}{A vector of the group means for a column.}

\item{group_std_devs}{A vector of group standard deviations for a column.}

\item{batch_shift}{A vector of batch means in a column.}

\item{batch_scale}{A vector of batch standard deviations within a column.}

\item{group_weights}{One of either a K x B matrix of the expected proportion 
of each batch in each group or a K-vector of the expected proportion of the
entire dataset in each group.}

\item{batch_weights}{A vector of the expected proportion of N in each batch.}

\item{type}{A string indicating if data should be generated from
multivariate normal ("MVN") or multivariate t ("MVT") densities (defaults to
"MVN").}

\item{group_dfs}{A K-vector of the group specific degrees of freedom.}

\item{frac_known}{The number of items with known labels.}

\item{permute_variables}{Logical indicating if group and batch means and
standard deviations should be permuted in each column or not (defaults to
``TRUE``).}

\item{scale_data}{Logical indicating if data should be mean centred and 
standardised (defaults to ``FALSE``).}
}
\value{
A list of 5 objects; the data generated from the groups with and
without batch effects, the label indicating the generating group, the
batch label and the vector indicating training versus test.
}
\description{
Generate data from K multivaraite normal or multivariate t
distributions with additional noise from batches. Assumes independence across
columns. In each column the parameters are randomly permuted for both the
groups and batches.
}
\examples{
N <- 500
P <- 2
K <- 2
B <- 5
mean_dist <- 4
batch_dist <- 0.3
group_means <- seq(1, K) * mean_dist
batch_shift <- rnorm(B, mean = batch_dist, sd = batch_dist)
std_dev <- rep(2, K)
batch_var <- rep(1.2, B)
group_weights <- rep(1 / K, K)
batch_weights <- rep(1 / B, B)
dfs <- c(4, 7)
my_data <- generateBatchData(
  N,
  P,
  group_means,
  std_dev,
  batch_shift,
  batch_var,
  group_weights,
  batch_weights,
  type = "MVT",
  group_dfs = dfs
)
}
