% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{batch_report}
\alias{batch_report}
\title{Batch Report}
\usage{
batch_report(path)
}
\arguments{
\item{path}{A string of the path to the directory with the files for processing.}
}
\value{
An invisible NULL. The function is called for its side-effect of
outputting a report of the status of individual files to the console.
}
\description{
Outputs a report of the status of individual files to the console.
}
\examples{
path <- tempdir()
write.csv(mtcars, file.path(path, "file1.csv"))
batch_config(function(x) TRUE, path, regexp = "[.]csv$",)
batch_report(path)
batch_run(path, ask = FALSE)
batch_report(path)
batch_cleanup(path)
unlink(file.path(path, "file1.csv"))
}
\seealso{
\code{\link[=batch_file_status]{batch_file_status()}}
}
