% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doJobCollection.R
\name{doJobCollection}
\alias{doJobCollection}
\title{Execute Jobs of a JobCollection}
\usage{
doJobCollection(jc, output = NULL)
}
\arguments{
\item{jc}{[\code{\link{JobCollection}}]\cr
Either an object of class \dQuote{JobCollection} as returned by
\code{\link{makeJobCollection}} or a string with the path to file
containing a \dQuote{JobCollection} as RDS file (as stored by \code{\link{submitJobs}}).}

\item{output}{[\code{character(1)}]\cr
Path to a file to write the output to. Defaults to \code{NULL} which means
that output is written to the active \code{\link[base]{sink}}.
Do not set this if your scheduler redirects output to a log file.}
}
\value{
[\code{character(1)}]: Hash of the \code{\link{JobCollection}} executed.
}
\description{
Executes every job in a \code{\link{JobCollection}}.
This function is intended to be called on the slave.
}
\examples{
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
batchMap(identity, 1:2, reg = tmp)
jc = makeJobCollection(1:2, reg = tmp)
doJobCollection(jc)
}
\seealso{
Other JobCollection: \code{\link{makeJobCollection}}
}
