% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.R
\name{mse}
\alias{mse}
\title{mse}
\usage{
mse(posterior, expected, adjMatrix, type = "emse")
}
\arguments{
\item{posterior}{A list of baycn objects or posterior probability adjacency
matrices. Each element in posterior can also be a list. For example, if
multiple data sets were generated under the same simulation scheme and baycn
was run on each data set, the input list could be a list containing the
output from each run of baycn. In this scenario the mean and standard
deviation of of the edgewise or whole graph MSE would be output.}

\item{expected}{The expected edge state probabilities for each edge. This
must be a matrix with the expected probability for the three edge states
across the columns and each edge down the rows.}

\item{adjMatrix}{This is only required if the input to posterior is a
posterior probability adjacency matrix (for example, output from the BiDAG or
structmcmc pacakges). This matrix will be used to convert the posterior
probability adjacency matrix to an edge state matrix. Only the edges in
adjMatrix will be converted to the edge state matrix. To consider all
possible edges use a fully connected adjacency matrix.}

\item{type}{A character string indicating the type of MSE to be calculated.
The two options are 'emse' - edge-wise MSE or 'gmse' - whole graph MSE.}
}
\description{
Calculates either the edge-wise or whole graph MSE. If more than one data set
is input the mean and standard deviation of the MSE will be calculated.
}
\examples{

set.seed(3)

# Generate data from topology M2.
data_m2 <- simdata(graph = 'm2_ge',
                   N = 200,
                   b0 = 0,
                   ss = 1,
                   s = 1)

# Adjacency matrix for topology M2
am_m2 <- matrix(c(0, 1, 1,
                  0, 0, 1,
                  0, 0, 0),
                byrow = TRUE,
                nrow = 3)

# Run baycn on the data from topology M2.
baycn_m2 <- mhEdge(data = data_m2,
                   adjMatrix = am_m2,
                   prior = c(0.05,
                             0.05,
                             0.9),
                   nCPh = 0,
                   nGV = 0,
                   pmr = FALSE,
                   iterations = 1000,
                   burnIn = 0.2,
                   thinTo = 500,
                   progress = FALSE)

# Expected probabilities for topology M2.
ep_m2 <- matrix(c(1, 0, 0,
                  0, 0, 1,
                  0, 1, 0),
                byrow = TRUE,
                ncol = 3)

# Calculate the edgewise MSE.
emse_m2 <- mse(posterior = list(baycn_m2),
               expected = ep_m2,
               type = 'emse')

\donttest{
# When a list with two levels is passed posterior the mean and standard
# deviation of the MSE is returned. Below is an example demonstrating this
# feature.

# Adjacency matrix for topology M2
am_m2 <- matrix(c(0, 1, 1,
                  0, 0, 1,
                  0, 0, 0),
                byrow = TRUE,
                nrow = 3)

# Create a list to hold multiple M2 data sets.
data_m2 <- vector(mode = 'list',
                  length = 5)

# Create a list to hold the output from baycn.
baycn_m2 <- vector(mode = 'list',
                   length = 5)

for (e in 1:5) {

  # Generate data for topology M2.
  data_m2[[e]] <- simdata(graph = 'm2_ge',
                          N = 200,
                          b0 = 0,
                          ss = 1,
                          s = 1)

  # Run baycn on the data simulated for topology M2.
  baycn_m2[[e]] <- mhEdge(data = data_m2[[e]],
                          adjMatrix = am_m2,
                          prior = c(0.05,
                                    0.05,
                                    0.9),
                          nCPh = 0,
                          nGV = 0,
                          pmr = FALSE,
                          iterations = 1000,
                          burnIn = 0.2,
                          thinTo = 500,
                          progress = FALSE)
}

# Expected probabilities for topology M2.
ep_m2 <- matrix(c(1, 0, 0,
                  0, 0, 1,
                  0, 1, 0),
                byrow = TRUE,
                ncol = 3)

# Calculate the edgewise MSE
emse_m2 <- mse(posterior = list(baycn_m2),
               expected = ep_m2,
               type = 'emse')

}

}
