% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest_class.R
\docType{class}
\name{ttest_class-class}
\alias{ttest_class-class}
\alias{ttest_class}
\title{ttest_class}
\description{
An S4 class for storing results of Bayesian t-test results.

\strong{Functions}

summary(`ttest_class`): prints a summary of the fit.

print(`ttest_class`): prints a more detailed summary of the fit

show(`ttest_class`): prints a more detailed summary of the fit.

plot(`ttest_class`): plots fitted model against the data. Use this function to explore the quality of your fit.

plot_fit(`ttest_class`): plots fitted model against the data. Use this function to explore the quality of your fit.

plot_trace(`ttest_class`): traceplot for main fitted model parameters.

get_parameters(`ttest_class`): returns a dataframe with values of fitted parameters.

compare_means(`ttest_class`, fit2=`ttest_class`): prints difference/equality of the first group against the second group. You can also provide the rope parameter or execute the comparison through the sigma or nu parameter.

compare_means(`ttest_class`, mu=`numeric`): prints difference/equality of the first group against a mean value. You can also provide the rope parameter or execute the comparison through the sigma parameter.

compare_means(`ttest_class`, mu=`numeric`, sigma=`numeric`): prints difference/equality of the first group against a normal distribution provided with mean value and standard deviation. Note here that sigma is used only in the Cohen's d calculation. You can also provide the rope parameter or execute the comparison through the sigma or nu parameter.

compare_means(`ttest_class`, fits=`list`): prints difference/equality of the first group and multiple other groups. You can also provide the rope parameter or execute the comparison through the sigma or nu parameter.

plot_means_difference(`ttest_class`, fit2=`ttest_class`): a visualization of the difference between the first group and the second group. You can also provide the rope and bins (number of bins in the histogram) parameters or visualize the comparison through the sigma or nu parameter.

plot_means_difference(`ttest_class`, mu=`numeric`): a visualization of the difference between the first group and a constant value or a normal distribution with mean value mu. You can also provide the rope and bins (number of bins in the histogram) parameters or visualize the comparison through the sigma or nu parameter.

plot_means_difference(`ttest_class`, fits=`list`): a visualization of the difference between multiple groups. You can also provide the rope and bins (number of bins in the histogram) parameters or visualize the comparison through the sigma or nu parameter.

plot_means(`ttest_class`): plots density of means. You can also visualize the density for the sigma or nu parameter.

plot_means(`ttest_class`, fit2=`ttest_class`): plots density for the first and the second group means. You can also visualize the density for the sigma or nu parameter.

plot_means(`ttest_class`, mu=`numeric`): plots density for the first group means and a mean value in case second group is defined as a normal distribution or as a constant. You can also visualize the density for the sigma or nu parameter.

plot_means(`ttest_class`, fits=`list`): plots density for the first group means and means for multiple other groups. You can also visualize the density for the sigma or nu parameter.

compare_distributions(`ttest_class`, fit2=`ttest_class`): draws samples from distribution of the first group and compares them against samples drawn from the distribution of the second group. You can also provide the rope parameter.

compare_distributions(`ttest_class`, mu=`numeric`): draws samples from distribution of the first group and compares them against a mean value. You can also provide the rope parameter.

compare_distributions(`ttest_class`, mu=`numeric`, sigma=`numeric`): draws samples from distribution of the first group and compares them against samples from a normal distribution with a defined mean value and variance. You can also provide the rope parameter.

compare_distributions(`ttest_class`, fits=`list`): draws samples from distribution of the first group and compares them against samples drawn from multiple other groups. You can also provide the rope parameter.

plot_distributions(`ttest_class`): a visualization of the fitted distribution.

plot_distributions(`ttest_class`, fit2=`ttest_class`): a visualization of two fitted distributions.

plot_distributions(`ttest_class`, mu=`numeric`): a visualization of the fitted distribution and a constant value.

plot_distributions(`ttest_class`, mu=`numeric`, sigma=`numeric`): a visualization of the fitted distribution and the normal distribution defined with a mean value and a standard deviation.

plot_distributions(`ttest_class`, fits=`list`): a visualization of multiple fitted distributions.

plot_distributions_difference(`ttest_class`, fit2=`ttest_class`): a visualization of the difference between the distribution of the first group and the distribution of the second group. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_distributions_difference(`ttest_class`, mu=`numeric`): a visualization of the difference between the distribution of the first group and a constant value. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_distributions_difference(`ttest_class`, mu=`numeric`, sigma=`numeric`): a visualization of the difference between the distribution of the first group and the normal distribution defined with a mean value and standard deviation. You can also provide the rope and bins (number of bins in the histogram) parameters.

plot_distributions_difference(`ttest_class`, fits=`list`): a visualization of the difference between multiple groups. You can also provide the rope and bins (number of bins in the histogram) parameters.
}
\section{Slots}{

\describe{
\item{\code{extract}}{Extract from Stan fit.}

\item{\code{fit}}{Stan fit.}

\item{\code{data}}{Raw data for the tested group.}
}}

\examples{
\donttest{
# priors
mu_prior <- b_prior(family="normal", pars=c(0, 1000))
sigma_prior <- b_prior(family="uniform", pars=c(0, 500))
nu_prior <- b_prior(family="normal", pars=c(2000, 1000))

# attach priors to relevant parameters
priors <- list(c("mu", mu_prior),
               c("sigma", sigma_prior),
               c("nu", nu_prior))

# generate data and fit
data1 <- rnorm(20, mean=150, sd=20)
fit1 <- b_ttest(data=data1, priors=priors, chains=1)

data2 <- rnorm(20, mean=200, sd=20)
fit2 <- b_ttest(data=data2, priors=priors, chains=1)

data3 <- rnorm(20, mean=150, sd=40)
fit3 <- b_ttest(data=data3, priors=priors, chains=1)

data4 <- rnorm(20, mean=50, sd=10)
fit4 <- b_ttest(data=data4, priors=priors, chains=1)

# fit list
fit_list <- list(fit2, fit3, fit4)

# a short summary of fitted parameters
summary(fit1)

# a more detailed summary of fitted parameters
print(fit1)
show(fit1)

# plot the fitted distribution against the data
plot(fit1)
plot_fit(fit1)

# traceplot of the fitted parameters
plot_trace(fit1)

# extract parameter values from the fit
parameters <- get_parameters(fit1)

# compare means between two fits
compare_means(fit1, fit2=fit2)

# compare means between two fits, use a rope interval
compare_means(fit1, fit2=fit2, rope=2)

# compare means between a fit and a constant value
compare_means(fit1, mu=150)

# compare means between a fit and a distribution,
# sigma is used for calculating Cohen's d
compare_means(fit1, mu=150, sigma=20)

# compare means between multiple fits
compare_means(fit1, fits=fit_list)

# visualize difference in means between two fits,
# specify number of histogram bins
plot_means_difference(fit1, fit2=fit2, bins=20)

# visualize difference in means between a fit and a constant value
plot_means_difference(fit1, mu=150)

# visualize difference in means between multiple fits, use a rope interval
plot_means_difference(fit1, fits=fit_list, rope=2)

# visualize means of a single fit
plot_means(fit1)

# visualize means of two fits
plot_means(fit1, fit2=fit2)

# visualize means of a fit and a constant value
plot_means(fit1, mu=150)

# visualize means of multiple fits
plot_means(fit1, fits=fit_list)

# draw samples from distributions underlying two fits and compare them
compare_distributions(fit1, fit2=fit2)

# draw samples from a distribution underlying the fit
# and compare them with a constant, use a rope interval
compare_distributions(fit1, mu=150, rope=2)

# draw samples from a distribution underlying the fit and
# compare them with a user defined distribution
compare_distributions(fit1, mu=150, sigma=20)

# draw samples from distributions underlying multiple fits and compare them
compare_distributions(fit1, fits=fit_list)

# visualize the distribution underlying a fit
plot_distributions(fit1)

# visualize distributions underlying two fits
plot_distributions(fit1, fit2=fit2)

# visualize the distribution underlying a fit and a constant value
plot_distributions(fit1, mu=150)

# visualize the distribution underlying a fit and a user defined distribution
plot_distributions(fit1, mu=150, sigma=20)

# visualize distributions underlying multiple fits
plot_distributions(fit1, fits=fit_list)

# visualize difference between distributions underlying two fits,
# use a rope interval
plot_distributions_difference(fit1, fit2=fit2, rope=2)

# visualize difference between a distribution underlying the fit
# and a constant value
plot_distributions_difference(fit1, mu=150)

# visualize difference between a distribution underlying the fits
# and a user defined distribution
plot_distributions_difference(fit1, mu=150, sigma=20)

# visualize difference between distributions underlying multiple fits
plot_distributions_difference(fit1, fits=fit_list)
}

}
