% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcPotts.R
\name{swNoData}
\alias{swNoData}
\title{Simulate pixel labels using the Swendsen-Wang algorithm.}
\usage{
swNoData(beta, k, neighbors, blocks, niter = 1000, random = TRUE)
}
\arguments{
\item{beta}{The inverse temperature parameter of the Potts model.}

\item{k}{The number of unique labels.}

\item{neighbors}{A matrix of all neighbors in the lattice, one row per pixel.}

\item{blocks}{A list of pixel indices, dividing the lattice into independent blocks.}

\item{niter}{The number of iterations of the algorithm to perform.}

\item{random}{Whether to initialize the labels using random or deterministic starting values.}
}
\value{
A list containing the following elements:
\describe{
  \item{\code{alloc}}{An n by k matrix containing the number of times that pixel i was allocated to label j.}
  \item{\code{z}}{An \code{(n+1)} by k matrix containing the final sample from the Potts model after niter iterations of Swendsen-Wang.}
  \item{\code{sum}}{An \code{niter} by 1 matrix containing the sum of like neighbors, i.e. the sufficient statistic of the Potts model, at each iteration.}
  }
}
\description{
The algorithm of Swendsen & Wang (1987) forms clusters of neighbouring pixels,
then updates all of the labels within a cluster to the same value. When
simulating from the prior, such as a Potts model without an external field,
this algorithm is very efficient.
}
\examples{
# Swendsen-Wang for a 2x2 lattice
neigh <- matrix(c(5,2,5,3,  1,5,5,4,  5,4,1,5,  3,5,2,5), nrow=4, ncol=4, byrow=TRUE)
blocks <- list(c(1,4), c(2,3))
res.sw <- swNoData(0.7, 3, neigh, blocks, niter=200)
res.sw$z
res.sw$sum[200]
}
\references{
Swendsen, R. H. & Wang, J.-S. (1987) "Nonuniversal critical dynamics in Monte Carlo simulations" \emph{Physical Review Letters} \bold{58}(2), 86--88, DOI: \href{https://doi.org/10.1103/PhysRevLett.58.86}{10.1103/PhysRevLett.58.86}
}
\seealso{
\code{\link[PottsUtils]{SW}}
}
