
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_psyip_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psyip");
    reader.add_event(112, 112, "end", "model_psyip");
    return reader;
}

class model_psyip : public prob_grad {
private:
    int nSampledCells;
    vector<int> N;
    vector<int> y;
    double q;
    double minP;
public:
    model_psyip(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psyip(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psyip_namespace::model_psyip";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
        nSampledCells = int(0);
        vals_i__ = context__.vals_i("nSampledCells");
        pos__ = 0;
        nSampledCells = vals_i__[pos__++];
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        N = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        y = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "q", "double", context__.to_vec());
        q = double(0);
        vals_r__ = context__.vals_r("q");
        pos__ = 0;
        q = vals_r__[pos__++];
        context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
        minP = double(0);
        vals_r__ = context__.vals_r("minP");
        pos__ = 0;
        minP = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"minP",minP,q);
        check_less_or_equal(function__,"minP",minP,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        ++num_params_r__;
    }

    ~model_psyip() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psy_Sampled")))
            throw std::runtime_error("variable psy_Sampled missing");
        vals_r__ = context__.vals_r("psy_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psy_Sampled", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration psy_Sampled
        vector_d psy_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psy_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("p")))
            throw std::runtime_error("variable p missing");
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        context__.validate_dims("initialization", "p", "double", context__.to_vec());
        // generate_declaration p
        double p(0);
        p = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(stan::math::fmax(minP,q),1,p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_Sampled;
        (void) psy_Sampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

        T__ p;
        (void) p;  // dummy to suppress unused var warning
        if (jacobian__)
            p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1,lp__);
        else
            p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1);


        // transformed parameters
        T__ qRate;
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, DUMMY_VAR__);
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, DUMMY_VAR__);
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 23;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 25;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        if (stan::math::is_uninitialized(qRate)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: qRate";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // model body
        try {

            current_statement_begin__ = 39;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 42;
            lp_accum__.add(beta_log(psy_Sampled,0.5,0.5));
            current_statement_begin__ = 45;
            lp_accum__.add(lLh_cell);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psy_Sampled");
        names__.push_back("p");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("psy");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psyip_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        double p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psy_Sampled[k_0__]);
        }
        vars__.push_back(p);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        double qRate(0.0);
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 23;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 25;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // write transformed parameters
        vars__.push_back(qRate);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
        vector<int> sim_y(nSampledCells, 0);
        stan::math::fill(sim_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
        vector<int> sim_true_y(nSampledCells, 0);
        stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
        vector<int> sim_false_y(nSampledCells, 0);
        stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
        double psy(0.0);
        (void) psy;  // dummy to suppress unused var warning

        stan::math::initialize(psy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy,DUMMY_VAR__);
        validate_non_negative_index("cellpres_i", "nSampledCells", nSampledCells);
        vector<double> cellpres_i(nSampledCells, 0.0);
        stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cellpres_i,DUMMY_VAR__);
        validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
        vector<double> pCorr(nSampledCells, 0.0);
        stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pCorr,DUMMY_VAR__);
        validate_non_negative_index("pp", "nSampledCells", nSampledCells);
        vector_d pp(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) pp;  // dummy to suppress unused var warning

        stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pp,DUMMY_VAR__);
        validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
        vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) expRec;  // dummy to suppress unused var warning

        stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(expRec,DUMMY_VAR__);
        double chi_sq(0.0);
        (void) chi_sq;  // dummy to suppress unused var warning

        stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(chi_sq,DUMMY_VAR__);
        double npars(0.0);
        (void) npars;  // dummy to suppress unused var warning

        stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(npars,DUMMY_VAR__);
        double lLh(0.0);
        (void) lLh;  // dummy to suppress unused var warning

        stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh,DUMMY_VAR__);
        double AIC(0.0);
        (void) AIC;  // dummy to suppress unused var warning

        stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AIC,DUMMY_VAR__);
        double AICc(0.0);
        (void) AICc;  // dummy to suppress unused var warning

        stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AICc,DUMMY_VAR__);
        double bAIC(0.0);
        (void) bAIC;  // dummy to suppress unused var warning

        stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bAIC,DUMMY_VAR__);


        try {
            current_statement_begin__ = 70;
            stan::math::assign(npars, (nSampledCells + 1));
            current_statement_begin__ = 73;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 74;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 76;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 77;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 78;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 81;
            stan::math::assign(expRec, add(multiply(elt_multiply(psy_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psy_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 82;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 84;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 86;
                stan::math::assign(get_base1_lhs(pp,ncell,"pp",1), exp(((log(get_base1(psy_Sampled,ncell,"psy_Sampled",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p)) - log_mix(get_base1(psy_Sampled,ncell,"psy_Sampled",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 92;
                if (as_bool(bernoulli_rng(get_base1(pp,ncell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 93;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 1);
                    current_statement_begin__ = 94;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), p);
                    current_statement_begin__ = 95;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),p, base_rng__));
                    current_statement_begin__ = 96;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 99;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 0);
                    current_statement_begin__ = 100;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 101;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 102;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 105;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 109;
            stan::math::assign(psy, (sum(cellpres_i) / nSampledCells));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
        }
        check_greater_or_equal(function__,"psy",psy,0);
        check_less_or_equal(function__,"psy",psy,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
            check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
            check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
        }
        check_greater_or_equal(function__,"pp",pp,0);
        check_less_or_equal(function__,"pp",pp,1);

        // write generated quantities
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
        }
        vars__.push_back(psy);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
        }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psyip";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_psyip_CAR_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psyip_CAR");
    reader.add_event(187, 187, "end", "model_psyip_CAR");
    return reader;
}

template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            validate_non_negative_index("phit_D", "n", n);
            Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_D(static_cast<Eigen::VectorXd::Index>(n));
            (void) phit_D;  // dummy to suppress unused var warning

            stan::math::initialize(phit_D, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(phit_D,DUMMY_VAR__);
            validate_non_negative_index("phit_W", "n", n);
            Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_W(static_cast<Eigen::VectorXd::Index>(n));
            (void) phit_W;  // dummy to suppress unused var warning

            stan::math::initialize(phit_W, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(phit_W,DUMMY_VAR__);
            validate_non_negative_index("ldet_terms", "n", n);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ldet_terms(static_cast<Eigen::VectorXd::Index>(n));
            (void) ldet_terms;  // dummy to suppress unused var warning

            stan::math::initialize(ldet_terms, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ldet_terms,DUMMY_VAR__);


            current_statement_begin__ = 24;
            stan::math::assign(phit_D, transpose(elt_multiply(phi,D_sparse)));
            current_statement_begin__ = 25;
            stan::math::assign(phit_W, rep_row_vector(0,n));
            current_statement_begin__ = 26;
            for (int i = 1; i <= W_n; ++i) {

                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phi",1)));
                current_statement_begin__ = 28;
                stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phi",1)));
            }
            current_statement_begin__ = 31;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(ldet_terms,i,"ldet_terms",1), log1m((alpha * get_base1(lambda,i,"lambda",1))));
            }
            current_statement_begin__ = 32;
            return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((n * log(tau)) + sum(ldet_terms)) - (tau * (multiply(phit_D,phi) - (alpha * multiply(phit_W,phi)))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    return sparse_car_lpdf<false>(phi,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__);
}


struct sparse_car_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) const {
        return sparse_car_lpdf(phi, tau, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__);
    }
};

class model_psyip_CAR : public prob_grad {
private:
    int nSampledCells;
    vector<int> sampledId;
    int nNotSampled;
    vector<int> notSampledId;
    int n;
    int W_n;
    vector<vector<int> > W_sparse;
    vector_d D_sparse;
    vector_d lambda;
    vector<int> N;
    vector<int> y;
    double q;
    double minP;
public:
    model_psyip_CAR(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psyip_CAR(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psyip_CAR_namespace::model_psyip_CAR";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
        nSampledCells = int(0);
        vals_i__ = context__.vals_i("nSampledCells");
        pos__ = 0;
        nSampledCells = vals_i__[pos__++];
        validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "sampledId", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
        sampledId = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("sampledId");
        pos__ = 0;
        size_t sampledId_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < sampledId_limit_0__; ++i_0__) {
            sampledId[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "nNotSampled", "int", context__.to_vec());
        nNotSampled = int(0);
        vals_i__ = context__.vals_i("nNotSampled");
        pos__ = 0;
        nNotSampled = vals_i__[pos__++];
        validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
        context__.validate_dims("data initialization", "notSampledId", "int", context__.to_vec(nNotSampled));
        validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
        notSampledId = std::vector<int>(nNotSampled,int(0));
        vals_i__ = context__.vals_i("notSampledId");
        pos__ = 0;
        size_t notSampledId_limit_0__ = nNotSampled;
        for (size_t i_0__ = 0; i_0__ < notSampledId_limit_0__; ++i_0__) {
            notSampledId[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "W_n", "int", context__.to_vec());
        W_n = int(0);
        vals_i__ = context__.vals_i("W_n");
        pos__ = 0;
        W_n = vals_i__[pos__++];
        validate_non_negative_index("W_sparse", "W_n", W_n);
        validate_non_negative_index("W_sparse", "2", 2);
        context__.validate_dims("data initialization", "W_sparse", "int", context__.to_vec(W_n,2));
        validate_non_negative_index("W_sparse", "W_n", W_n);
        validate_non_negative_index("W_sparse", "2", 2);
        W_sparse = std::vector<std::vector<int> >(W_n,std::vector<int>(2,int(0)));
        vals_i__ = context__.vals_i("W_sparse");
        pos__ = 0;
        size_t W_sparse_limit_1__ = 2;
        for (size_t i_1__ = 0; i_1__ < W_sparse_limit_1__; ++i_1__) {
            size_t W_sparse_limit_0__ = W_n;
            for (size_t i_0__ = 0; i_0__ < W_sparse_limit_0__; ++i_0__) {
                W_sparse[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        validate_non_negative_index("D_sparse", "n", n);
        context__.validate_dims("data initialization", "D_sparse", "vector_d", context__.to_vec(n));
        validate_non_negative_index("D_sparse", "n", n);
        D_sparse = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("D_sparse");
        pos__ = 0;
        size_t D_sparse_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < D_sparse_i_vec_lim__; ++i_vec__) {
            D_sparse[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("lambda", "n", n);
        context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(n));
        validate_non_negative_index("lambda", "n", n);
        lambda = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0;
        size_t lambda_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < lambda_i_vec_lim__; ++i_vec__) {
            lambda[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        N = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        y = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "q", "double", context__.to_vec());
        q = double(0);
        vals_r__ = context__.vals_r("q");
        pos__ = 0;
        q = vals_r__[pos__++];
        context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
        minP = double(0);
        vals_r__ = context__.vals_r("minP");
        pos__ = 0;
        minP = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sampledId[k0__]",sampledId[k0__],1);
        }
        check_greater_or_equal(function__,"nNotSampled",nNotSampled,0);
        for (int k0__ = 0; k0__ < nNotSampled; ++k0__) {
            check_greater_or_equal(function__,"notSampledId[k0__]",notSampledId[k0__],1);
        }
        check_greater_or_equal(function__,"n",n,1);
        check_greater_or_equal(function__,"W_n",W_n,1);
        for (int k0__ = 0; k0__ < W_n; ++k0__) {
            for (int k1__ = 0; k1__ < 2; ++k1__) {
                check_greater_or_equal(function__,"W_sparse[k0__][k1__]",W_sparse[k0__][k1__],1);
            }
        }
        check_greater_or_equal(function__,"D_sparse",D_sparse,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"minP",minP,q);
        check_less_or_equal(function__,"minP",minP,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        validate_non_negative_index("psy_NotSampled", "nNotSampled", nNotSampled);
        num_params_r__ += nNotSampled;
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
    }

    ~model_psyip_CAR() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psy_Sampled")))
            throw std::runtime_error("variable psy_Sampled missing");
        vals_r__ = context__.vals_r("psy_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psy_Sampled", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration psy_Sampled
        vector_d psy_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psy_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("psy_NotSampled")))
            throw std::runtime_error("variable psy_NotSampled missing");
        vals_r__ = context__.vals_r("psy_NotSampled");
        pos__ = 0U;
        validate_non_negative_index("psy_NotSampled", "nNotSampled", nNotSampled);
        context__.validate_dims("initialization", "psy_NotSampled", "vector_d", context__.to_vec(nNotSampled));
        // generate_declaration psy_NotSampled
        vector_d psy_NotSampled(static_cast<Eigen::VectorXd::Index>(nNotSampled));
        for (int j1__ = 0U; j1__ < nNotSampled; ++j1__)
            psy_NotSampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_NotSampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_NotSampled: ") + e.what());
        }

        if (!(context__.contains_r("p")))
            throw std::runtime_error("variable p missing");
        vals_r__ = context__.vals_r("p");
        pos__ = 0U;
        context__.validate_dims("initialization", "p", "double", context__.to_vec());
        // generate_declaration p
        double p(0);
        p = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(stan::math::fmax(minP,q),1,p);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        // generate_declaration tau
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        // generate_declaration alpha
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_Sampled;
        (void) psy_Sampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_NotSampled;
        (void) psy_NotSampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled,lp__);
        else
            psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);

        T__ p;
        (void) p;  // dummy to suppress unused var warning
        if (jacobian__)
            p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1,lp__);
        else
            p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1);

        T__ tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.scalar_lb_constrain(0,lp__);
        else
            tau = in__.scalar_lb_constrain(0);

        T__ alpha;
        (void) alpha;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha = in__.scalar_lub_constrain(0,1,lp__);
        else
            alpha = in__.scalar_lub_constrain(0,1);


        // transformed parameters
        validate_non_negative_index("psy_i", "n", n);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_i(static_cast<Eigen::VectorXd::Index>(n));
        (void) psy_i;  // dummy to suppress unused var warning

        stan::math::initialize(psy_i, DUMMY_VAR__);
        stan::math::fill(psy_i,DUMMY_VAR__);
        T__ qRate;
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, DUMMY_VAR__);
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, DUMMY_VAR__);
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 76;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psy_Sampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 77;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psy_NotSampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 78;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 80;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 82;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < n; ++i0__) {
            if (stan::math::is_uninitialized(psy_i(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: psy_i" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(qRate)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: qRate";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"psy_i",psy_i,0);
        check_less_or_equal(function__,"psy_i",psy_i,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // model body
        try {

            current_statement_begin__ = 97;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 100;
            lp_accum__.add(beta_log(psy_i,0.5,0.5));
            current_statement_begin__ = 101;
            lp_accum__.add(gamma_log(tau,2,2));
            current_statement_begin__ = 104;
            lp_accum__.add(lLh_cell);
            current_statement_begin__ = 112;
            lp_accum__.add(sparse_car_lpdf(psy_i,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psy_Sampled");
        names__.push_back("psy_NotSampled");
        names__.push_back("p");
        names__.push_back("tau");
        names__.push_back("alpha");
        names__.push_back("psy_i");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("cell");
        names__.push_back("psy");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nNotSampled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psyip_CAR_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);
        double p = in__.scalar_lub_constrain(stan::math::fmax(minP,q),1);
        double tau = in__.scalar_lb_constrain(0);
        double alpha = in__.scalar_lub_constrain(0,1);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psy_Sampled[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nNotSampled; ++k_0__) {
            vars__.push_back(psy_NotSampled[k_0__]);
        }
        vars__.push_back(p);
        vars__.push_back(tau);
        vars__.push_back(alpha);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("psy_i", "n", n);
        vector_d psy_i(static_cast<Eigen::VectorXd::Index>(n));
        (void) psy_i;  // dummy to suppress unused var warning

        stan::math::initialize(psy_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy_i,DUMMY_VAR__);
        double qRate(0.0);
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 76;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psy_Sampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 77;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psy_NotSampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 78;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 80;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 82;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"psy_i",psy_i,0);
        check_less_or_equal(function__,"psy_i",psy_i,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(psy_i[k_0__]);
        }
        vars__.push_back(qRate);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
        vector<int> sim_y(nSampledCells, 0);
        stan::math::fill(sim_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
        vector<int> sim_true_y(nSampledCells, 0);
        stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
        vector<int> sim_false_y(nSampledCells, 0);
        stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
        int cell(0);
        (void) cell;  // dummy to suppress unused var warning

        stan::math::fill(cell, std::numeric_limits<int>::min());
        double psy(0.0);
        (void) psy;  // dummy to suppress unused var warning

        stan::math::initialize(psy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy,DUMMY_VAR__);
        validate_non_negative_index("cellpres_i", "n", n);
        vector<double> cellpres_i(n, 0.0);
        stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cellpres_i,DUMMY_VAR__);
        validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
        vector<double> pCorr(nSampledCells, 0.0);
        stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pCorr,DUMMY_VAR__);
        validate_non_negative_index("pp", "n", n);
        vector_d pp(static_cast<Eigen::VectorXd::Index>(n));
        (void) pp;  // dummy to suppress unused var warning

        stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pp,DUMMY_VAR__);
        validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
        vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) expRec;  // dummy to suppress unused var warning

        stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(expRec,DUMMY_VAR__);
        double chi_sq(0.0);
        (void) chi_sq;  // dummy to suppress unused var warning

        stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(chi_sq,DUMMY_VAR__);
        double npars(0.0);
        (void) npars;  // dummy to suppress unused var warning

        stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(npars,DUMMY_VAR__);
        double lLh(0.0);
        (void) lLh;  // dummy to suppress unused var warning

        stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh,DUMMY_VAR__);
        double AIC(0.0);
        (void) AIC;  // dummy to suppress unused var warning

        stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AIC,DUMMY_VAR__);
        double AICc(0.0);
        (void) AICc;  // dummy to suppress unused var warning

        stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AICc,DUMMY_VAR__);
        double bAIC(0.0);
        (void) bAIC;  // dummy to suppress unused var warning

        stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bAIC,DUMMY_VAR__);


        try {
            current_statement_begin__ = 137;
            stan::math::assign(npars, ((((nSampledCells + nNotSampled) + 1) + 1) + 1));
            current_statement_begin__ = 140;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 141;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 142;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 143;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 146;
            stan::math::assign(expRec, add(multiply(elt_multiply(psy_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psy_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 147;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 150;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 152;
                stan::math::assign(cell, get_base1(sampledId,ncell,"sampledId",1));
                current_statement_begin__ = 153;
                stan::math::assign(get_base1_lhs(pp,cell,"pp",1), exp(((log(get_base1(psy_i,cell,"psy_i",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p)) - log_mix(get_base1(psy_i,cell,"psy_i",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 159;
                if (as_bool(bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 160;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 1);
                    current_statement_begin__ = 161;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), p);
                    current_statement_begin__ = 162;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),p, base_rng__));
                    current_statement_begin__ = 163;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 166;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 0);
                    current_statement_begin__ = 167;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 168;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 169;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 172;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 176;
            stan::model::assign(pp, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        stan::model::rvalue(psy_i, stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), "psy_i"), 
                        "assigning variable pp");
            current_statement_begin__ = 178;
            for (int ncell = 1; ncell <= nNotSampled; ++ncell) {

                current_statement_begin__ = 179;
                stan::math::assign(cell, get_base1(notSampledId,ncell,"notSampledId",1));
                current_statement_begin__ = 180;
                stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__));
            }
            current_statement_begin__ = 184;
            stan::math::assign(psy, (sum(cellpres_i) / n));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
        }
        check_greater_or_equal(function__,"cell",cell,1);
        check_greater_or_equal(function__,"psy",psy,0);
        check_less_or_equal(function__,"psy",psy,1);
        for (int k0__ = 0; k0__ < n; ++k0__) {
            check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
            check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
            check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
        }
        check_greater_or_equal(function__,"pp",pp,0);
        check_less_or_equal(function__,"pp",pp,1);

        // write generated quantities
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
        }
        vars__.push_back(cell);
        vars__.push_back(psy);
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(pp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
        }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psyip_CAR";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_psyipi_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psyipi");
    reader.add_event(129, 129, "end", "model_psyipi");
    return reader;
}

class model_psyipi : public prob_grad {
private:
    int nSampledCells;
    vector<int> N;
    vector<int> y;
    double q;
    double minP;
public:
    model_psyipi(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psyipi(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psyipi_namespace::model_psyipi";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
        nSampledCells = int(0);
        vals_i__ = context__.vals_i("nSampledCells");
        pos__ = 0;
        nSampledCells = vals_i__[pos__++];
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        N = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        y = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "q", "double", context__.to_vec());
        q = double(0);
        vals_r__ = context__.vals_r("q");
        pos__ = 0;
        q = vals_r__[pos__++];
        context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
        minP = double(0);
        vals_r__ = context__.vals_r("minP");
        pos__ = 0;
        minP = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"minP",minP,q);
        check_less_or_equal(function__,"minP",minP,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        validate_non_negative_index("odds", "2", 2);
        num_params_r__ += 2;
    }

    ~model_psyipi() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psy_Sampled")))
            throw std::runtime_error("variable psy_Sampled missing");
        vals_r__ = context__.vals_r("psy_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psy_Sampled", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration psy_Sampled
        vector_d psy_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psy_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("p_raw")))
            throw std::runtime_error("variable p_raw missing");
        vals_r__ = context__.vals_r("p_raw");
        pos__ = 0U;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "p_raw", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration p_raw
        vector_d p_raw(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            p_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,p_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_raw: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "2", 2);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(2));
        // generate_declaration odds
        vector_d odds(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_Sampled;
        (void) psy_Sampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  p_raw;
        (void) p_raw;  // dummy to suppress unused var warning
        if (jacobian__)
            p_raw = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            p_raw = in__.vector_lub_constrain(0,1,nSampledCells);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
        (void) odds;  // dummy to suppress unused var warning
        if (jacobian__)
            odds = in__.ordered_constrain(2,lp__);
        else
            odds = in__.ordered_constrain(2);


        // transformed parameters
        T__ pRange;
        (void) pRange;  // dummy to suppress unused var warning

        stan::math::initialize(pRange, DUMMY_VAR__);
        stan::math::fill(pRange,DUMMY_VAR__);
        validate_non_negative_index("p", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, DUMMY_VAR__);
        stan::math::fill(p,DUMMY_VAR__);
        T__ pmax;
        (void) pmax;  // dummy to suppress unused var warning

        stan::math::initialize(pmax, DUMMY_VAR__);
        stan::math::fill(pmax,DUMMY_VAR__);
        T__ pmin;
        (void) pmin;  // dummy to suppress unused var warning

        stan::math::initialize(pmin, DUMMY_VAR__);
        stan::math::fill(pmin,DUMMY_VAR__);
        T__ qRate;
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, DUMMY_VAR__);
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, DUMMY_VAR__);
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 30;
            stan::math::assign(pmin, ((inv_logit(get_base1(odds,1,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 31;
            stan::math::assign(pmax, ((inv_logit(get_base1(odds,2,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 34;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 35;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 37;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 40;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 42;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        if (stan::math::is_uninitialized(pRange)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pRange";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(p(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(pmax)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pmax";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(pmin)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pmin";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(qRate)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: qRate";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"pRange",pRange,0);
        check_less_or_equal(function__,"pRange",pRange,1);
        check_greater_or_equal(function__,"p",p,0);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"pmax",pmax,stan::math::fmax(minP,q));
        check_less_or_equal(function__,"pmax",pmax,1);
        check_greater_or_equal(function__,"pmin",pmin,stan::math::fmax(minP,q));
        check_less_or_equal(function__,"pmin",pmin,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // model body
        try {

            current_statement_begin__ = 54;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 55;
            lp_accum__.add(normal_log(pRange,0,0.10000000000000001));
            current_statement_begin__ = 57;
            lp_accum__.add(normal_log(pmin,0.5,0.25));
            current_statement_begin__ = 58;
            lp_accum__.add(normal_log(p_raw,1,0.25));
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log(pmax,0.5,0.25));
            current_statement_begin__ = 62;
            lp_accum__.add(beta_log(psy_Sampled,0.5,0.5));
            current_statement_begin__ = 64;
            lp_accum__.add(lLh_cell);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psy_Sampled");
        names__.push_back("p_raw");
        names__.push_back("odds");
        names__.push_back("pRange");
        names__.push_back("p");
        names__.push_back("pmax");
        names__.push_back("pmin");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("psy");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psyipi_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d p_raw = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d odds = in__.ordered_constrain(2);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psy_Sampled[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p_raw[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(odds[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        double pRange(0.0);
        (void) pRange;  // dummy to suppress unused var warning

        stan::math::initialize(pRange, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pRange,DUMMY_VAR__);
        validate_non_negative_index("p", "nSampledCells", nSampledCells);
        vector_d p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);
        double pmax(0.0);
        (void) pmax;  // dummy to suppress unused var warning

        stan::math::initialize(pmax, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmax,DUMMY_VAR__);
        double pmin(0.0);
        (void) pmin;  // dummy to suppress unused var warning

        stan::math::initialize(pmin, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmin,DUMMY_VAR__);
        double qRate(0.0);
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 30;
            stan::math::assign(pmin, ((inv_logit(get_base1(odds,1,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 31;
            stan::math::assign(pmax, ((inv_logit(get_base1(odds,2,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 34;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 35;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 37;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 40;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 42;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"pRange",pRange,0);
        check_less_or_equal(function__,"pRange",pRange,1);
        check_greater_or_equal(function__,"p",p,0);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"pmax",pmax,stan::math::fmax(minP,q));
        check_less_or_equal(function__,"pmax",pmax,1);
        check_greater_or_equal(function__,"pmin",pmin,stan::math::fmax(minP,q));
        check_less_or_equal(function__,"pmin",pmin,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // write transformed parameters
        vars__.push_back(pRange);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p[k_0__]);
        }
        vars__.push_back(pmax);
        vars__.push_back(pmin);
        vars__.push_back(qRate);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
        vector<int> sim_y(nSampledCells, 0);
        stan::math::fill(sim_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
        vector<int> sim_true_y(nSampledCells, 0);
        stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
        vector<int> sim_false_y(nSampledCells, 0);
        stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
        double psy(0.0);
        (void) psy;  // dummy to suppress unused var warning

        stan::math::initialize(psy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy,DUMMY_VAR__);
        validate_non_negative_index("cellpres_i", "nSampledCells", nSampledCells);
        vector<double> cellpres_i(nSampledCells, 0.0);
        stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cellpres_i,DUMMY_VAR__);
        validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
        vector<double> pCorr(nSampledCells, 0.0);
        stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pCorr,DUMMY_VAR__);
        validate_non_negative_index("pp", "nSampledCells", nSampledCells);
        vector_d pp(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) pp;  // dummy to suppress unused var warning

        stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pp,DUMMY_VAR__);
        validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
        vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) expRec;  // dummy to suppress unused var warning

        stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(expRec,DUMMY_VAR__);
        double chi_sq(0.0);
        (void) chi_sq;  // dummy to suppress unused var warning

        stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(chi_sq,DUMMY_VAR__);
        double npars(0.0);
        (void) npars;  // dummy to suppress unused var warning

        stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(npars,DUMMY_VAR__);
        double lLh(0.0);
        (void) lLh;  // dummy to suppress unused var warning

        stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh,DUMMY_VAR__);
        double AIC(0.0);
        (void) AIC;  // dummy to suppress unused var warning

        stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AIC,DUMMY_VAR__);
        double AICc(0.0);
        (void) AICc;  // dummy to suppress unused var warning

        stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AICc,DUMMY_VAR__);
        double bAIC(0.0);
        (void) bAIC;  // dummy to suppress unused var warning

        stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bAIC,DUMMY_VAR__);


        try {
            current_statement_begin__ = 89;
            stan::math::assign(npars, ((nSampledCells + nSampledCells) + 2));
            current_statement_begin__ = 91;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 92;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 93;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 94;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 97;
            stan::math::assign(expRec, add(elt_multiply(elt_multiply(psy_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psy_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 98;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 101;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 103;
                stan::math::assign(get_base1_lhs(pp,ncell,"pp",1), exp(((log(get_base1(psy_Sampled,ncell,"psy_Sampled",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1))) - log_mix(get_base1(psy_Sampled,ncell,"psy_Sampled",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1)),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 109;
                if (as_bool(bernoulli_rng(get_base1(pp,ncell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 110;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 1);
                    current_statement_begin__ = 111;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), get_base1(p,ncell,"p",1));
                    current_statement_begin__ = 112;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1), base_rng__));
                    current_statement_begin__ = 113;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 116;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 0);
                    current_statement_begin__ = 117;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 118;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 119;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 122;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 126;
            stan::math::assign(psy, (sum(cellpres_i) / nSampledCells));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
        }
        check_greater_or_equal(function__,"psy",psy,0);
        check_less_or_equal(function__,"psy",psy,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
            check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
            check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
        }
        check_greater_or_equal(function__,"pp",pp,0);
        check_less_or_equal(function__,"pp",pp,1);

        // write generated quantities
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
        }
        vars__.push_back(psy);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
        }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psyipi";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_psyipi_CAR_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psyipi_CAR");
    reader.add_event(202, 202, "end", "model_psyipi_CAR");
    return reader;
}

template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            validate_non_negative_index("phit_D", "n", n);
            Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_D(static_cast<Eigen::VectorXd::Index>(n));
            (void) phit_D;  // dummy to suppress unused var warning

            stan::math::initialize(phit_D, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(phit_D,DUMMY_VAR__);
            validate_non_negative_index("phit_W", "n", n);
            Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_W(static_cast<Eigen::VectorXd::Index>(n));
            (void) phit_W;  // dummy to suppress unused var warning

            stan::math::initialize(phit_W, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(phit_W,DUMMY_VAR__);
            validate_non_negative_index("ldet_terms", "n", n);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ldet_terms(static_cast<Eigen::VectorXd::Index>(n));
            (void) ldet_terms;  // dummy to suppress unused var warning

            stan::math::initialize(ldet_terms, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ldet_terms,DUMMY_VAR__);


            current_statement_begin__ = 24;
            stan::math::assign(phit_D, transpose(elt_multiply(phi,D_sparse)));
            current_statement_begin__ = 25;
            stan::math::assign(phit_W, rep_row_vector(0,n));
            current_statement_begin__ = 26;
            for (int i = 1; i <= W_n; ++i) {

                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phi",1)));
                current_statement_begin__ = 28;
                stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phi",1)));
            }
            current_statement_begin__ = 31;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(ldet_terms,i,"ldet_terms",1), log1m((alpha * get_base1(lambda,i,"lambda",1))));
            }
            current_statement_begin__ = 32;
            return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((n * log(tau)) + sum(ldet_terms)) - (tau * (multiply(phit_D,phi) - (alpha * multiply(phit_W,phi)))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    return sparse_car_lpdf<false>(phi,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__);
}


struct sparse_car_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) const {
        return sparse_car_lpdf(phi, tau, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__);
    }
};

class model_psyipi_CAR : public prob_grad {
private:
    int nSampledCells;
    vector<int> sampledId;
    int nNotSampled;
    vector<int> notSampledId;
    int n;
    int W_n;
    vector<vector<int> > W_sparse;
    vector_d D_sparse;
    vector_d lambda;
    vector<int> N;
    vector<int> y;
    double q;
    double minP;
public:
    model_psyipi_CAR(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psyipi_CAR(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psyipi_CAR_namespace::model_psyipi_CAR";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
        nSampledCells = int(0);
        vals_i__ = context__.vals_i("nSampledCells");
        pos__ = 0;
        nSampledCells = vals_i__[pos__++];
        validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "sampledId", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
        sampledId = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("sampledId");
        pos__ = 0;
        size_t sampledId_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < sampledId_limit_0__; ++i_0__) {
            sampledId[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "nNotSampled", "int", context__.to_vec());
        nNotSampled = int(0);
        vals_i__ = context__.vals_i("nNotSampled");
        pos__ = 0;
        nNotSampled = vals_i__[pos__++];
        validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
        context__.validate_dims("data initialization", "notSampledId", "int", context__.to_vec(nNotSampled));
        validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
        notSampledId = std::vector<int>(nNotSampled,int(0));
        vals_i__ = context__.vals_i("notSampledId");
        pos__ = 0;
        size_t notSampledId_limit_0__ = nNotSampled;
        for (size_t i_0__ = 0; i_0__ < notSampledId_limit_0__; ++i_0__) {
            notSampledId[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "W_n", "int", context__.to_vec());
        W_n = int(0);
        vals_i__ = context__.vals_i("W_n");
        pos__ = 0;
        W_n = vals_i__[pos__++];
        validate_non_negative_index("W_sparse", "W_n", W_n);
        validate_non_negative_index("W_sparse", "2", 2);
        context__.validate_dims("data initialization", "W_sparse", "int", context__.to_vec(W_n,2));
        validate_non_negative_index("W_sparse", "W_n", W_n);
        validate_non_negative_index("W_sparse", "2", 2);
        W_sparse = std::vector<std::vector<int> >(W_n,std::vector<int>(2,int(0)));
        vals_i__ = context__.vals_i("W_sparse");
        pos__ = 0;
        size_t W_sparse_limit_1__ = 2;
        for (size_t i_1__ = 0; i_1__ < W_sparse_limit_1__; ++i_1__) {
            size_t W_sparse_limit_0__ = W_n;
            for (size_t i_0__ = 0; i_0__ < W_sparse_limit_0__; ++i_0__) {
                W_sparse[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        validate_non_negative_index("D_sparse", "n", n);
        context__.validate_dims("data initialization", "D_sparse", "vector_d", context__.to_vec(n));
        validate_non_negative_index("D_sparse", "n", n);
        D_sparse = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("D_sparse");
        pos__ = 0;
        size_t D_sparse_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < D_sparse_i_vec_lim__; ++i_vec__) {
            D_sparse[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("lambda", "n", n);
        context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(n));
        validate_non_negative_index("lambda", "n", n);
        lambda = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0;
        size_t lambda_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < lambda_i_vec_lim__; ++i_vec__) {
            lambda[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        N = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        y = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "q", "double", context__.to_vec());
        q = double(0);
        vals_r__ = context__.vals_r("q");
        pos__ = 0;
        q = vals_r__[pos__++];
        context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
        minP = double(0);
        vals_r__ = context__.vals_r("minP");
        pos__ = 0;
        minP = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sampledId[k0__]",sampledId[k0__],1);
        }
        check_greater_or_equal(function__,"nNotSampled",nNotSampled,0);
        for (int k0__ = 0; k0__ < nNotSampled; ++k0__) {
            check_greater_or_equal(function__,"notSampledId[k0__]",notSampledId[k0__],1);
        }
        check_greater_or_equal(function__,"n",n,1);
        check_greater_or_equal(function__,"W_n",W_n,1);
        for (int k0__ = 0; k0__ < W_n; ++k0__) {
            for (int k1__ = 0; k1__ < 2; ++k1__) {
                check_greater_or_equal(function__,"W_sparse[k0__][k1__]",W_sparse[k0__][k1__],1);
            }
        }
        check_greater_or_equal(function__,"D_sparse",D_sparse,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"minP",minP,q);
        check_less_or_equal(function__,"minP",minP,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        validate_non_negative_index("psy_NotSampled", "nNotSampled", nNotSampled);
        num_params_r__ += nNotSampled;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        ++num_params_r__;
        ++num_params_r__;
        validate_non_negative_index("odds", "2", 2);
        num_params_r__ += 2;
    }

    ~model_psyipi_CAR() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psy_Sampled")))
            throw std::runtime_error("variable psy_Sampled missing");
        vals_r__ = context__.vals_r("psy_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psy_Sampled", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration psy_Sampled
        vector_d psy_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psy_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("psy_NotSampled")))
            throw std::runtime_error("variable psy_NotSampled missing");
        vals_r__ = context__.vals_r("psy_NotSampled");
        pos__ = 0U;
        validate_non_negative_index("psy_NotSampled", "nNotSampled", nNotSampled);
        context__.validate_dims("initialization", "psy_NotSampled", "vector_d", context__.to_vec(nNotSampled));
        // generate_declaration psy_NotSampled
        vector_d psy_NotSampled(static_cast<Eigen::VectorXd::Index>(nNotSampled));
        for (int j1__ = 0U; j1__ < nNotSampled; ++j1__)
            psy_NotSampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_NotSampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_NotSampled: ") + e.what());
        }

        if (!(context__.contains_r("p_raw")))
            throw std::runtime_error("variable p_raw missing");
        vals_r__ = context__.vals_r("p_raw");
        pos__ = 0U;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "p_raw", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration p_raw
        vector_d p_raw(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            p_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,p_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_raw: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        // generate_declaration tau
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        // generate_declaration alpha
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "2", 2);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(2));
        // generate_declaration odds
        vector_d odds(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_Sampled;
        (void) psy_Sampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_NotSampled;
        (void) psy_NotSampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled,lp__);
        else
            psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  p_raw;
        (void) p_raw;  // dummy to suppress unused var warning
        if (jacobian__)
            p_raw = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            p_raw = in__.vector_lub_constrain(0,1,nSampledCells);

        T__ tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.scalar_lb_constrain(0,lp__);
        else
            tau = in__.scalar_lb_constrain(0);

        T__ alpha;
        (void) alpha;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha = in__.scalar_lub_constrain(0,1,lp__);
        else
            alpha = in__.scalar_lub_constrain(0,1);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
        (void) odds;  // dummy to suppress unused var warning
        if (jacobian__)
            odds = in__.ordered_constrain(2,lp__);
        else
            odds = in__.ordered_constrain(2);


        // transformed parameters
        T__ qRate;
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, DUMMY_VAR__);
        stan::math::fill(qRate,DUMMY_VAR__);
        T__ pRange;
        (void) pRange;  // dummy to suppress unused var warning

        stan::math::initialize(pRange, DUMMY_VAR__);
        stan::math::fill(pRange,DUMMY_VAR__);
        validate_non_negative_index("psy_i", "n", n);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_i(static_cast<Eigen::VectorXd::Index>(n));
        (void) psy_i;  // dummy to suppress unused var warning

        stan::math::initialize(psy_i, DUMMY_VAR__);
        stan::math::fill(psy_i,DUMMY_VAR__);
        validate_non_negative_index("p", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, DUMMY_VAR__);
        stan::math::fill(p,DUMMY_VAR__);
        T__ pmax;
        (void) pmax;  // dummy to suppress unused var warning

        stan::math::initialize(pmax, DUMMY_VAR__);
        stan::math::fill(pmax,DUMMY_VAR__);
        T__ pmin;
        (void) pmin;  // dummy to suppress unused var warning

        stan::math::initialize(pmin, DUMMY_VAR__);
        stan::math::fill(pmin,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, DUMMY_VAR__);
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 80;
            stan::math::assign(pmin, ((inv_logit(get_base1(odds,1,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 81;
            stan::math::assign(pmax, ((inv_logit(get_base1(odds,2,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 83;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psy_Sampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 84;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psy_NotSampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 85;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 86;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 89;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 91;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 93;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        if (stan::math::is_uninitialized(qRate)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: qRate";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(pRange)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pRange";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < n; ++i0__) {
            if (stan::math::is_uninitialized(psy_i(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: psy_i" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(p(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(pmax)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pmax";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(pmin)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pmin";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);
        check_greater_or_equal(function__,"pRange",pRange,0);
        check_less_or_equal(function__,"pRange",pRange,1);
        check_greater_or_equal(function__,"psy_i",psy_i,0);
        check_less_or_equal(function__,"psy_i",psy_i,1);
        check_greater_or_equal(function__,"p",p,0);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"pmax",pmax,stan::math::fmax(minP,q));
        check_less_or_equal(function__,"pmax",pmax,1);
        check_greater_or_equal(function__,"pmin",pmin,stan::math::fmax(minP,q));
        check_less_or_equal(function__,"pmin",pmin,1);

        // model body
        try {

            current_statement_begin__ = 107;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 108;
            lp_accum__.add(normal_log(pRange,0,0.10000000000000001));
            current_statement_begin__ = 110;
            lp_accum__.add(normal_log(pmin,0.5,0.25));
            current_statement_begin__ = 111;
            lp_accum__.add(normal_log(p_raw,1,0.25));
            current_statement_begin__ = 113;
            lp_accum__.add(normal_log(pmax,0.5,0.25));
            current_statement_begin__ = 115;
            lp_accum__.add(beta_log(psy_i,0.5,0.5));
            current_statement_begin__ = 116;
            lp_accum__.add(gamma_log(tau,2,2));
            current_statement_begin__ = 120;
            lp_accum__.add(lLh_cell);
            current_statement_begin__ = 127;
            lp_accum__.add(sparse_car_lpdf(psy_i,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psy_Sampled");
        names__.push_back("psy_NotSampled");
        names__.push_back("p_raw");
        names__.push_back("tau");
        names__.push_back("alpha");
        names__.push_back("odds");
        names__.push_back("qRate");
        names__.push_back("pRange");
        names__.push_back("psy_i");
        names__.push_back("p");
        names__.push_back("pmax");
        names__.push_back("pmin");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("cell");
        names__.push_back("psy");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nNotSampled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psyipi_CAR_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);
        vector_d p_raw = in__.vector_lub_constrain(0,1,nSampledCells);
        double tau = in__.scalar_lb_constrain(0);
        double alpha = in__.scalar_lub_constrain(0,1);
        vector_d odds = in__.ordered_constrain(2);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psy_Sampled[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nNotSampled; ++k_0__) {
            vars__.push_back(psy_NotSampled[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p_raw[k_0__]);
        }
        vars__.push_back(tau);
        vars__.push_back(alpha);
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(odds[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        double qRate(0.0);
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(qRate,DUMMY_VAR__);
        double pRange(0.0);
        (void) pRange;  // dummy to suppress unused var warning

        stan::math::initialize(pRange, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pRange,DUMMY_VAR__);
        validate_non_negative_index("psy_i", "n", n);
        vector_d psy_i(static_cast<Eigen::VectorXd::Index>(n));
        (void) psy_i;  // dummy to suppress unused var warning

        stan::math::initialize(psy_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy_i,DUMMY_VAR__);
        validate_non_negative_index("p", "nSampledCells", nSampledCells);
        vector_d p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);
        double pmax(0.0);
        (void) pmax;  // dummy to suppress unused var warning

        stan::math::initialize(pmax, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmax,DUMMY_VAR__);
        double pmin(0.0);
        (void) pmin;  // dummy to suppress unused var warning

        stan::math::initialize(pmin, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmin,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 80;
            stan::math::assign(pmin, ((inv_logit(get_base1(odds,1,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 81;
            stan::math::assign(pmax, ((inv_logit(get_base1(odds,2,"odds",1)) * (1 - stan::math::fmax(minP,q))) + stan::math::fmax(minP,q)));
            current_statement_begin__ = 83;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psy_Sampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 84;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psy_NotSampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 85;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 86;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 89;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 91;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 93;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);
        check_greater_or_equal(function__,"pRange",pRange,0);
        check_less_or_equal(function__,"pRange",pRange,1);
        check_greater_or_equal(function__,"psy_i",psy_i,0);
        check_less_or_equal(function__,"psy_i",psy_i,1);
        check_greater_or_equal(function__,"p",p,0);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"pmax",pmax,stan::math::fmax(minP,q));
        check_less_or_equal(function__,"pmax",pmax,1);
        check_greater_or_equal(function__,"pmin",pmin,stan::math::fmax(minP,q));
        check_less_or_equal(function__,"pmin",pmin,1);

        // write transformed parameters
        vars__.push_back(qRate);
        vars__.push_back(pRange);
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(psy_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p[k_0__]);
        }
        vars__.push_back(pmax);
        vars__.push_back(pmin);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
        vector<int> sim_y(nSampledCells, 0);
        stan::math::fill(sim_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
        vector<int> sim_true_y(nSampledCells, 0);
        stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
        vector<int> sim_false_y(nSampledCells, 0);
        stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
        int cell(0);
        (void) cell;  // dummy to suppress unused var warning

        stan::math::fill(cell, std::numeric_limits<int>::min());
        double psy(0.0);
        (void) psy;  // dummy to suppress unused var warning

        stan::math::initialize(psy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy,DUMMY_VAR__);
        validate_non_negative_index("cellpres_i", "n", n);
        vector<double> cellpres_i(n, 0.0);
        stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cellpres_i,DUMMY_VAR__);
        validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
        vector<double> pCorr(nSampledCells, 0.0);
        stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pCorr,DUMMY_VAR__);
        validate_non_negative_index("pp", "n", n);
        vector_d pp(static_cast<Eigen::VectorXd::Index>(n));
        (void) pp;  // dummy to suppress unused var warning

        stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pp,DUMMY_VAR__);
        validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
        vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) expRec;  // dummy to suppress unused var warning

        stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(expRec,DUMMY_VAR__);
        double chi_sq(0.0);
        (void) chi_sq;  // dummy to suppress unused var warning

        stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(chi_sq,DUMMY_VAR__);
        double npars(0.0);
        (void) npars;  // dummy to suppress unused var warning

        stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(npars,DUMMY_VAR__);
        double lLh(0.0);
        (void) lLh;  // dummy to suppress unused var warning

        stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh,DUMMY_VAR__);
        double AIC(0.0);
        (void) AIC;  // dummy to suppress unused var warning

        stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AIC,DUMMY_VAR__);
        double AICc(0.0);
        (void) AICc;  // dummy to suppress unused var warning

        stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AICc,DUMMY_VAR__);
        double bAIC(0.0);
        (void) bAIC;  // dummy to suppress unused var warning

        stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bAIC,DUMMY_VAR__);


        try {
            current_statement_begin__ = 152;
            stan::math::assign(npars, (((((nSampledCells + nNotSampled) + nSampledCells) + 1) + 1) + 2));
            current_statement_begin__ = 155;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 156;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 157;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 158;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 161;
            stan::math::assign(expRec, add(elt_multiply(elt_multiply(psy_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psy_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 162;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 165;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 167;
                stan::math::assign(cell, get_base1(sampledId,ncell,"sampledId",1));
                current_statement_begin__ = 168;
                stan::math::assign(get_base1_lhs(pp,cell,"pp",1), exp(((log(get_base1(psy_i,cell,"psy_i",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1))) - log_mix(get_base1(psy_i,cell,"psy_i",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1)),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 174;
                if (as_bool(bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 175;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 1);
                    current_statement_begin__ = 176;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), get_base1(p,ncell,"p",1));
                    current_statement_begin__ = 177;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1), base_rng__));
                    current_statement_begin__ = 178;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 181;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 0);
                    current_statement_begin__ = 182;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 183;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 184;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 187;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 191;
            stan::model::assign(pp, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        stan::model::rvalue(psy_i, stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), "psy_i"), 
                        "assigning variable pp");
            current_statement_begin__ = 193;
            for (int ncell = 1; ncell <= nNotSampled; ++ncell) {

                current_statement_begin__ = 194;
                stan::math::assign(cell, get_base1(notSampledId,ncell,"notSampledId",1));
                current_statement_begin__ = 195;
                stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__));
            }
            current_statement_begin__ = 199;
            stan::math::assign(psy, (sum(cellpres_i) / n));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
        }
        check_greater_or_equal(function__,"cell",cell,1);
        check_greater_or_equal(function__,"psy",psy,0);
        check_less_or_equal(function__,"psy",psy,1);
        for (int k0__ = 0; k0__ < n; ++k0__) {
            check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
            check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
            check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
        }
        check_greater_or_equal(function__,"pp",pp,0);
        check_less_or_equal(function__,"pp",pp,1);

        // write generated quantities
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
        }
        vars__.push_back(cell);
        vars__.push_back(psy);
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(pp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
        }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psyipi_CAR";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_psyipiq_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psyipiq");
    reader.add_event(130, 130, "end", "model_psyipiq");
    return reader;
}

class model_psyipiq : public prob_grad {
private:
    int nSampledCells;
    vector<int> N;
    vector<int> y;
    double minP;
public:
    model_psyipiq(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psyipiq(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psyipiq_namespace::model_psyipiq";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
        nSampledCells = int(0);
        vals_i__ = context__.vals_i("nSampledCells");
        pos__ = 0;
        nSampledCells = vals_i__[pos__++];
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        N = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        y = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
        minP = double(0);
        vals_r__ = context__.vals_r("minP");
        pos__ = 0;
        minP = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        check_greater_or_equal(function__,"minP",minP,0);
        check_less_or_equal(function__,"minP",minP,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        validate_non_negative_index("odds", "3", 3);
        num_params_r__ += 3;
    }

    ~model_psyipiq() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psy_Sampled")))
            throw std::runtime_error("variable psy_Sampled missing");
        vals_r__ = context__.vals_r("psy_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psy_Sampled", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration psy_Sampled
        vector_d psy_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psy_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("p_raw")))
            throw std::runtime_error("variable p_raw missing");
        vals_r__ = context__.vals_r("p_raw");
        pos__ = 0U;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "p_raw", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration p_raw
        vector_d p_raw(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            p_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,p_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_raw: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "3", 3);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(3));
        // generate_declaration odds
        vector_d odds(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_Sampled;
        (void) psy_Sampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  p_raw;
        (void) p_raw;  // dummy to suppress unused var warning
        if (jacobian__)
            p_raw = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            p_raw = in__.vector_lub_constrain(0,1,nSampledCells);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
        (void) odds;  // dummy to suppress unused var warning
        if (jacobian__)
            odds = in__.ordered_constrain(3,lp__);
        else
            odds = in__.ordered_constrain(3);


        // transformed parameters
        T__ q;
        (void) q;  // dummy to suppress unused var warning

        stan::math::initialize(q, DUMMY_VAR__);
        stan::math::fill(q,DUMMY_VAR__);
        T__ pmax;
        (void) pmax;  // dummy to suppress unused var warning

        stan::math::initialize(pmax, DUMMY_VAR__);
        stan::math::fill(pmax,DUMMY_VAR__);
        T__ pmin;
        (void) pmin;  // dummy to suppress unused var warning

        stan::math::initialize(pmin, DUMMY_VAR__);
        stan::math::fill(pmin,DUMMY_VAR__);
        T__ qRate;
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, DUMMY_VAR__);
        stan::math::fill(qRate,DUMMY_VAR__);
        T__ pRange;
        (void) pRange;  // dummy to suppress unused var warning

        stan::math::initialize(pRange, DUMMY_VAR__);
        stan::math::fill(pRange,DUMMY_VAR__);
        validate_non_negative_index("p", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, DUMMY_VAR__);
        stan::math::fill(p,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, DUMMY_VAR__);
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 30;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 31;
            stan::math::assign(pmin, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 32;
            stan::math::assign(pmax, inv_logit(get_base1(odds,3,"odds",1)));
            current_statement_begin__ = 34;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 35;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 36;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 38;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 40;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        if (stan::math::is_uninitialized(q)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: q";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(pmax)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pmax";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(pmin)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pmin";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(qRate)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: qRate";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(pRange)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pRange";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(p(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"pmax",pmax,minP);
        check_less_or_equal(function__,"pmax",pmax,1);
        check_greater_or_equal(function__,"pmin",pmin,minP);
        check_less_or_equal(function__,"pmin",pmin,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);
        check_greater_or_equal(function__,"pRange",pRange,0);
        check_less_or_equal(function__,"pRange",pRange,1);
        check_greater_or_equal(function__,"p",p,0);
        check_less_or_equal(function__,"p",p,1);

        // model body
        try {

            current_statement_begin__ = 53;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 54;
            lp_accum__.add(normal_log(pRange,0,0.10000000000000001));
            current_statement_begin__ = 57;
            lp_accum__.add(normal_log(pmin,0.5,0.25));
            current_statement_begin__ = 58;
            lp_accum__.add(normal_log(p_raw,1,0.25));
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log(pmax,0.5,0.25));
            current_statement_begin__ = 62;
            lp_accum__.add(beta_log(psy_Sampled,0.5,0.5));
            current_statement_begin__ = 64;
            lp_accum__.add(lLh_cell);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psy_Sampled");
        names__.push_back("p_raw");
        names__.push_back("odds");
        names__.push_back("q");
        names__.push_back("pmax");
        names__.push_back("pmin");
        names__.push_back("qRate");
        names__.push_back("pRange");
        names__.push_back("p");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("psy");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psyipiq_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d p_raw = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d odds = in__.ordered_constrain(3);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psy_Sampled[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p_raw[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(odds[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        double q(0.0);
        (void) q;  // dummy to suppress unused var warning

        stan::math::initialize(q, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(q,DUMMY_VAR__);
        double pmax(0.0);
        (void) pmax;  // dummy to suppress unused var warning

        stan::math::initialize(pmax, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmax,DUMMY_VAR__);
        double pmin(0.0);
        (void) pmin;  // dummy to suppress unused var warning

        stan::math::initialize(pmin, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmin,DUMMY_VAR__);
        double qRate(0.0);
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(qRate,DUMMY_VAR__);
        double pRange(0.0);
        (void) pRange;  // dummy to suppress unused var warning

        stan::math::initialize(pRange, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pRange,DUMMY_VAR__);
        validate_non_negative_index("p", "nSampledCells", nSampledCells);
        vector_d p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 30;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 31;
            stan::math::assign(pmin, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 32;
            stan::math::assign(pmax, inv_logit(get_base1(odds,3,"odds",1)));
            current_statement_begin__ = 34;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 35;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 36;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 38;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 40;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"pmax",pmax,minP);
        check_less_or_equal(function__,"pmax",pmax,1);
        check_greater_or_equal(function__,"pmin",pmin,minP);
        check_less_or_equal(function__,"pmin",pmin,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);
        check_greater_or_equal(function__,"pRange",pRange,0);
        check_less_or_equal(function__,"pRange",pRange,1);
        check_greater_or_equal(function__,"p",p,0);
        check_less_or_equal(function__,"p",p,1);

        // write transformed parameters
        vars__.push_back(q);
        vars__.push_back(pmax);
        vars__.push_back(pmin);
        vars__.push_back(qRate);
        vars__.push_back(pRange);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
        vector<int> sim_y(nSampledCells, 0);
        stan::math::fill(sim_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
        vector<int> sim_true_y(nSampledCells, 0);
        stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
        vector<int> sim_false_y(nSampledCells, 0);
        stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
        double psy(0.0);
        (void) psy;  // dummy to suppress unused var warning

        stan::math::initialize(psy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy,DUMMY_VAR__);
        validate_non_negative_index("cellpres_i", "nSampledCells", nSampledCells);
        vector<double> cellpres_i(nSampledCells, 0.0);
        stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cellpres_i,DUMMY_VAR__);
        validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
        vector<double> pCorr(nSampledCells, 0.0);
        stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pCorr,DUMMY_VAR__);
        validate_non_negative_index("pp", "nSampledCells", nSampledCells);
        vector_d pp(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) pp;  // dummy to suppress unused var warning

        stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pp,DUMMY_VAR__);
        validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
        vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) expRec;  // dummy to suppress unused var warning

        stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(expRec,DUMMY_VAR__);
        double chi_sq(0.0);
        (void) chi_sq;  // dummy to suppress unused var warning

        stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(chi_sq,DUMMY_VAR__);
        double npars(0.0);
        (void) npars;  // dummy to suppress unused var warning

        stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(npars,DUMMY_VAR__);
        double lLh(0.0);
        (void) lLh;  // dummy to suppress unused var warning

        stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh,DUMMY_VAR__);
        double AIC(0.0);
        (void) AIC;  // dummy to suppress unused var warning

        stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AIC,DUMMY_VAR__);
        double AICc(0.0);
        (void) AICc;  // dummy to suppress unused var warning

        stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AICc,DUMMY_VAR__);
        double bAIC(0.0);
        (void) bAIC;  // dummy to suppress unused var warning

        stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bAIC,DUMMY_VAR__);


        try {
            current_statement_begin__ = 89;
            stan::math::assign(npars, ((nSampledCells + nSampledCells) + 3));
            current_statement_begin__ = 92;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 93;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 94;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 95;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 98;
            stan::math::assign(expRec, add(elt_multiply(elt_multiply(psy_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psy_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 99;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 102;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 104;
                stan::math::assign(get_base1_lhs(pp,ncell,"pp",1), exp(((log(get_base1(psy_Sampled,ncell,"psy_Sampled",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1))) - log_mix(get_base1(psy_Sampled,ncell,"psy_Sampled",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1)),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 110;
                if (as_bool(bernoulli_rng(get_base1(pp,ncell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 111;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 1);
                    current_statement_begin__ = 112;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), get_base1(p,ncell,"p",1));
                    current_statement_begin__ = 113;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1), base_rng__));
                    current_statement_begin__ = 114;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 117;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 0);
                    current_statement_begin__ = 118;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 119;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 120;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 123;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 127;
            stan::math::assign(psy, (sum(cellpres_i) / nSampledCells));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
        }
        check_greater_or_equal(function__,"psy",psy,0);
        check_less_or_equal(function__,"psy",psy,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
            check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
            check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
        }
        check_greater_or_equal(function__,"pp",pp,0);
        check_less_or_equal(function__,"pp",pp,1);

        // write generated quantities
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
        }
        vars__.push_back(psy);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
        }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psyipiq";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_psyipiq_CAR_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psyipiq_CAR");
    reader.add_event(199, 199, "end", "model_psyipiq_CAR");
    return reader;
}

template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            validate_non_negative_index("phit_D", "n", n);
            Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_D(static_cast<Eigen::VectorXd::Index>(n));
            (void) phit_D;  // dummy to suppress unused var warning

            stan::math::initialize(phit_D, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(phit_D,DUMMY_VAR__);
            validate_non_negative_index("phit_W", "n", n);
            Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_W(static_cast<Eigen::VectorXd::Index>(n));
            (void) phit_W;  // dummy to suppress unused var warning

            stan::math::initialize(phit_W, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(phit_W,DUMMY_VAR__);
            validate_non_negative_index("ldet_terms", "n", n);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ldet_terms(static_cast<Eigen::VectorXd::Index>(n));
            (void) ldet_terms;  // dummy to suppress unused var warning

            stan::math::initialize(ldet_terms, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ldet_terms,DUMMY_VAR__);


            current_statement_begin__ = 24;
            stan::math::assign(phit_D, transpose(elt_multiply(phi,D_sparse)));
            current_statement_begin__ = 25;
            stan::math::assign(phit_W, rep_row_vector(0,n));
            current_statement_begin__ = 26;
            for (int i = 1; i <= W_n; ++i) {

                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phi",1)));
                current_statement_begin__ = 28;
                stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phi",1)));
            }
            current_statement_begin__ = 31;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(ldet_terms,i,"ldet_terms",1), log1m((alpha * get_base1(lambda,i,"lambda",1))));
            }
            current_statement_begin__ = 32;
            return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((n * log(tau)) + sum(ldet_terms)) - (tau * (multiply(phit_D,phi) - (alpha * multiply(phit_W,phi)))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    return sparse_car_lpdf<false>(phi,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__);
}


struct sparse_car_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) const {
        return sparse_car_lpdf(phi, tau, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__);
    }
};

class model_psyipiq_CAR : public prob_grad {
private:
    int nSampledCells;
    vector<int> sampledId;
    int nNotSampled;
    vector<int> notSampledId;
    int n;
    int W_n;
    vector<vector<int> > W_sparse;
    vector_d D_sparse;
    vector_d lambda;
    vector<int> N;
    vector<int> y;
    double minP;
public:
    model_psyipiq_CAR(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psyipiq_CAR(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psyipiq_CAR_namespace::model_psyipiq_CAR";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
        nSampledCells = int(0);
        vals_i__ = context__.vals_i("nSampledCells");
        pos__ = 0;
        nSampledCells = vals_i__[pos__++];
        validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "sampledId", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
        sampledId = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("sampledId");
        pos__ = 0;
        size_t sampledId_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < sampledId_limit_0__; ++i_0__) {
            sampledId[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "nNotSampled", "int", context__.to_vec());
        nNotSampled = int(0);
        vals_i__ = context__.vals_i("nNotSampled");
        pos__ = 0;
        nNotSampled = vals_i__[pos__++];
        validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
        context__.validate_dims("data initialization", "notSampledId", "int", context__.to_vec(nNotSampled));
        validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
        notSampledId = std::vector<int>(nNotSampled,int(0));
        vals_i__ = context__.vals_i("notSampledId");
        pos__ = 0;
        size_t notSampledId_limit_0__ = nNotSampled;
        for (size_t i_0__ = 0; i_0__ < notSampledId_limit_0__; ++i_0__) {
            notSampledId[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "W_n", "int", context__.to_vec());
        W_n = int(0);
        vals_i__ = context__.vals_i("W_n");
        pos__ = 0;
        W_n = vals_i__[pos__++];
        validate_non_negative_index("W_sparse", "W_n", W_n);
        validate_non_negative_index("W_sparse", "2", 2);
        context__.validate_dims("data initialization", "W_sparse", "int", context__.to_vec(W_n,2));
        validate_non_negative_index("W_sparse", "W_n", W_n);
        validate_non_negative_index("W_sparse", "2", 2);
        W_sparse = std::vector<std::vector<int> >(W_n,std::vector<int>(2,int(0)));
        vals_i__ = context__.vals_i("W_sparse");
        pos__ = 0;
        size_t W_sparse_limit_1__ = 2;
        for (size_t i_1__ = 0; i_1__ < W_sparse_limit_1__; ++i_1__) {
            size_t W_sparse_limit_0__ = W_n;
            for (size_t i_0__ = 0; i_0__ < W_sparse_limit_0__; ++i_0__) {
                W_sparse[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        validate_non_negative_index("D_sparse", "n", n);
        context__.validate_dims("data initialization", "D_sparse", "vector_d", context__.to_vec(n));
        validate_non_negative_index("D_sparse", "n", n);
        D_sparse = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("D_sparse");
        pos__ = 0;
        size_t D_sparse_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < D_sparse_i_vec_lim__; ++i_vec__) {
            D_sparse[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("lambda", "n", n);
        context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(n));
        validate_non_negative_index("lambda", "n", n);
        lambda = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0;
        size_t lambda_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < lambda_i_vec_lim__; ++i_vec__) {
            lambda[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        N = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        y = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
        minP = double(0);
        vals_r__ = context__.vals_r("minP");
        pos__ = 0;
        minP = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sampledId[k0__]",sampledId[k0__],1);
        }
        check_greater_or_equal(function__,"nNotSampled",nNotSampled,0);
        for (int k0__ = 0; k0__ < nNotSampled; ++k0__) {
            check_greater_or_equal(function__,"notSampledId[k0__]",notSampledId[k0__],1);
        }
        check_greater_or_equal(function__,"n",n,1);
        check_greater_or_equal(function__,"W_n",W_n,1);
        for (int k0__ = 0; k0__ < W_n; ++k0__) {
            for (int k1__ = 0; k1__ < 2; ++k1__) {
                check_greater_or_equal(function__,"W_sparse[k0__][k1__]",W_sparse[k0__][k1__],1);
            }
        }
        check_greater_or_equal(function__,"D_sparse",D_sparse,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        check_greater_or_equal(function__,"minP",minP,0);
        check_less_or_equal(function__,"minP",minP,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        validate_non_negative_index("psy_NotSampled", "nNotSampled", nNotSampled);
        num_params_r__ += nNotSampled;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        ++num_params_r__;
        ++num_params_r__;
        validate_non_negative_index("odds", "3", 3);
        num_params_r__ += 3;
    }

    ~model_psyipiq_CAR() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psy_Sampled")))
            throw std::runtime_error("variable psy_Sampled missing");
        vals_r__ = context__.vals_r("psy_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psy_Sampled", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration psy_Sampled
        vector_d psy_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psy_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("psy_NotSampled")))
            throw std::runtime_error("variable psy_NotSampled missing");
        vals_r__ = context__.vals_r("psy_NotSampled");
        pos__ = 0U;
        validate_non_negative_index("psy_NotSampled", "nNotSampled", nNotSampled);
        context__.validate_dims("initialization", "psy_NotSampled", "vector_d", context__.to_vec(nNotSampled));
        // generate_declaration psy_NotSampled
        vector_d psy_NotSampled(static_cast<Eigen::VectorXd::Index>(nNotSampled));
        for (int j1__ = 0U; j1__ < nNotSampled; ++j1__)
            psy_NotSampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_NotSampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_NotSampled: ") + e.what());
        }

        if (!(context__.contains_r("p_raw")))
            throw std::runtime_error("variable p_raw missing");
        vals_r__ = context__.vals_r("p_raw");
        pos__ = 0U;
        validate_non_negative_index("p_raw", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "p_raw", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration p_raw
        vector_d p_raw(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            p_raw(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,p_raw);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable p_raw: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        // generate_declaration tau
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        // generate_declaration alpha
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "3", 3);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(3));
        // generate_declaration odds
        vector_d odds(static_cast<Eigen::VectorXd::Index>(3));
        for (int j1__ = 0U; j1__ < 3; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_Sampled;
        (void) psy_Sampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_NotSampled;
        (void) psy_NotSampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled,lp__);
        else
            psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  p_raw;
        (void) p_raw;  // dummy to suppress unused var warning
        if (jacobian__)
            p_raw = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            p_raw = in__.vector_lub_constrain(0,1,nSampledCells);

        T__ tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.scalar_lb_constrain(0,lp__);
        else
            tau = in__.scalar_lb_constrain(0);

        T__ alpha;
        (void) alpha;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha = in__.scalar_lub_constrain(0,1,lp__);
        else
            alpha = in__.scalar_lub_constrain(0,1);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
        (void) odds;  // dummy to suppress unused var warning
        if (jacobian__)
            odds = in__.ordered_constrain(3,lp__);
        else
            odds = in__.ordered_constrain(3);


        // transformed parameters
        T__ q;
        (void) q;  // dummy to suppress unused var warning

        stan::math::initialize(q, DUMMY_VAR__);
        stan::math::fill(q,DUMMY_VAR__);
        T__ pmax;
        (void) pmax;  // dummy to suppress unused var warning

        stan::math::initialize(pmax, DUMMY_VAR__);
        stan::math::fill(pmax,DUMMY_VAR__);
        T__ pmin;
        (void) pmin;  // dummy to suppress unused var warning

        stan::math::initialize(pmin, DUMMY_VAR__);
        stan::math::fill(pmin,DUMMY_VAR__);
        T__ pRange;
        (void) pRange;  // dummy to suppress unused var warning

        stan::math::initialize(pRange, DUMMY_VAR__);
        stan::math::fill(pRange,DUMMY_VAR__);
        validate_non_negative_index("psy_i", "n", n);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_i(static_cast<Eigen::VectorXd::Index>(n));
        (void) psy_i;  // dummy to suppress unused var warning

        stan::math::initialize(psy_i, DUMMY_VAR__);
        stan::math::fill(psy_i,DUMMY_VAR__);
        validate_non_negative_index("p", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, DUMMY_VAR__);
        stan::math::fill(p,DUMMY_VAR__);
        T__ qRate;
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, DUMMY_VAR__);
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, DUMMY_VAR__);
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 79;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 80;
            stan::math::assign(pmin, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 81;
            stan::math::assign(pmax, inv_logit(get_base1(odds,3,"odds",1)));
            current_statement_begin__ = 84;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psy_Sampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 85;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psy_NotSampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 86;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 87;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 89;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 91;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 93;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        if (stan::math::is_uninitialized(q)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: q";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(pmax)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pmax";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(pmin)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pmin";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(pRange)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: pRange";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < n; ++i0__) {
            if (stan::math::is_uninitialized(psy_i(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: psy_i" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(p(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(qRate)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: qRate";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"pmax",pmax,minP);
        check_less_or_equal(function__,"pmax",pmax,1);
        check_greater_or_equal(function__,"pmin",pmin,minP);
        check_less_or_equal(function__,"pmin",pmin,1);
        check_greater_or_equal(function__,"pRange",pRange,0);
        check_less_or_equal(function__,"pRange",pRange,1);
        check_greater_or_equal(function__,"psy_i",psy_i,0);
        check_less_or_equal(function__,"psy_i",psy_i,1);
        check_greater_or_equal(function__,"p",p,0);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // model body
        try {

            current_statement_begin__ = 107;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 108;
            lp_accum__.add(normal_log(pRange,0,0.10000000000000001));
            current_statement_begin__ = 111;
            lp_accum__.add(normal_log(p_raw,1,0.25));
            current_statement_begin__ = 114;
            lp_accum__.add(beta_log(psy_i,0.5,0.5));
            current_statement_begin__ = 115;
            lp_accum__.add(gamma_log(tau,2,2));
            current_statement_begin__ = 118;
            lp_accum__.add(lLh_cell);
            current_statement_begin__ = 125;
            lp_accum__.add(sparse_car_lpdf(psy_i,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psy_Sampled");
        names__.push_back("psy_NotSampled");
        names__.push_back("p_raw");
        names__.push_back("tau");
        names__.push_back("alpha");
        names__.push_back("odds");
        names__.push_back("q");
        names__.push_back("pmax");
        names__.push_back("pmin");
        names__.push_back("pRange");
        names__.push_back("psy_i");
        names__.push_back("p");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("cell");
        names__.push_back("psy");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nNotSampled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psyipiq_CAR_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);
        vector_d p_raw = in__.vector_lub_constrain(0,1,nSampledCells);
        double tau = in__.scalar_lb_constrain(0);
        double alpha = in__.scalar_lub_constrain(0,1);
        vector_d odds = in__.ordered_constrain(3);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psy_Sampled[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nNotSampled; ++k_0__) {
            vars__.push_back(psy_NotSampled[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p_raw[k_0__]);
        }
        vars__.push_back(tau);
        vars__.push_back(alpha);
        for (int k_0__ = 0; k_0__ < 3; ++k_0__) {
            vars__.push_back(odds[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        double q(0.0);
        (void) q;  // dummy to suppress unused var warning

        stan::math::initialize(q, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(q,DUMMY_VAR__);
        double pmax(0.0);
        (void) pmax;  // dummy to suppress unused var warning

        stan::math::initialize(pmax, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmax,DUMMY_VAR__);
        double pmin(0.0);
        (void) pmin;  // dummy to suppress unused var warning

        stan::math::initialize(pmin, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pmin,DUMMY_VAR__);
        double pRange(0.0);
        (void) pRange;  // dummy to suppress unused var warning

        stan::math::initialize(pRange, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pRange,DUMMY_VAR__);
        validate_non_negative_index("psy_i", "n", n);
        vector_d psy_i(static_cast<Eigen::VectorXd::Index>(n));
        (void) psy_i;  // dummy to suppress unused var warning

        stan::math::initialize(psy_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy_i,DUMMY_VAR__);
        validate_non_negative_index("p", "nSampledCells", nSampledCells);
        vector_d p(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);
        double qRate(0.0);
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 79;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 80;
            stan::math::assign(pmin, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 81;
            stan::math::assign(pmax, inv_logit(get_base1(odds,3,"odds",1)));
            current_statement_begin__ = 84;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psy_Sampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 85;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psy_NotSampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 86;
            stan::math::assign(pRange, (pmax - pmin));
            current_statement_begin__ = 87;
            stan::math::assign(qRate, (q / pmin));
            current_statement_begin__ = 89;
            stan::math::assign(p, add(multiply(p_raw,pRange),pmin));
            current_statement_begin__ = 91;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 93;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),get_base1(p,cell,"p",1)),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"pmax",pmax,minP);
        check_less_or_equal(function__,"pmax",pmax,1);
        check_greater_or_equal(function__,"pmin",pmin,minP);
        check_less_or_equal(function__,"pmin",pmin,1);
        check_greater_or_equal(function__,"pRange",pRange,0);
        check_less_or_equal(function__,"pRange",pRange,1);
        check_greater_or_equal(function__,"psy_i",psy_i,0);
        check_less_or_equal(function__,"psy_i",psy_i,1);
        check_greater_or_equal(function__,"p",p,0);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // write transformed parameters
        vars__.push_back(q);
        vars__.push_back(pmax);
        vars__.push_back(pmin);
        vars__.push_back(pRange);
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(psy_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(p[k_0__]);
        }
        vars__.push_back(qRate);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
        vector<int> sim_y(nSampledCells, 0);
        stan::math::fill(sim_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
        vector<int> sim_true_y(nSampledCells, 0);
        stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
        vector<int> sim_false_y(nSampledCells, 0);
        stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
        int cell(0);
        (void) cell;  // dummy to suppress unused var warning

        stan::math::fill(cell, std::numeric_limits<int>::min());
        double psy(0.0);
        (void) psy;  // dummy to suppress unused var warning

        stan::math::initialize(psy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy,DUMMY_VAR__);
        validate_non_negative_index("cellpres_i", "n", n);
        vector<double> cellpres_i(n, 0.0);
        stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cellpres_i,DUMMY_VAR__);
        validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
        vector<double> pCorr(nSampledCells, 0.0);
        stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pCorr,DUMMY_VAR__);
        validate_non_negative_index("pp", "n", n);
        vector_d pp(static_cast<Eigen::VectorXd::Index>(n));
        (void) pp;  // dummy to suppress unused var warning

        stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pp,DUMMY_VAR__);
        validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
        vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) expRec;  // dummy to suppress unused var warning

        stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(expRec,DUMMY_VAR__);
        double chi_sq(0.0);
        (void) chi_sq;  // dummy to suppress unused var warning

        stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(chi_sq,DUMMY_VAR__);
        double npars(0.0);
        (void) npars;  // dummy to suppress unused var warning

        stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(npars,DUMMY_VAR__);
        double lLh(0.0);
        (void) lLh;  // dummy to suppress unused var warning

        stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh,DUMMY_VAR__);
        double AIC(0.0);
        (void) AIC;  // dummy to suppress unused var warning

        stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AIC,DUMMY_VAR__);
        double AICc(0.0);
        (void) AICc;  // dummy to suppress unused var warning

        stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AICc,DUMMY_VAR__);
        double bAIC(0.0);
        (void) bAIC;  // dummy to suppress unused var warning

        stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bAIC,DUMMY_VAR__);


        try {
            current_statement_begin__ = 150;
            stan::math::assign(npars, (((((nSampledCells + nNotSampled) + nSampledCells) + 1) + 1) + 3));
            current_statement_begin__ = 152;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 153;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 154;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 155;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 158;
            stan::math::assign(expRec, add(elt_multiply(elt_multiply(psy_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psy_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 159;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 162;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 164;
                stan::math::assign(cell, get_base1(sampledId,ncell,"sampledId",1));
                current_statement_begin__ = 165;
                stan::math::assign(get_base1_lhs(pp,cell,"pp",1), exp(((log(get_base1(psy_i,cell,"psy_i",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1))) - log_mix(get_base1(psy_i,cell,"psy_i",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1)),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 171;
                if (as_bool(bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 172;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 1);
                    current_statement_begin__ = 173;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), get_base1(p,ncell,"p",1));
                    current_statement_begin__ = 174;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),get_base1(p,ncell,"p",1), base_rng__));
                    current_statement_begin__ = 175;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 178;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 0);
                    current_statement_begin__ = 179;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 180;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 181;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 184;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 188;
            stan::model::assign(pp, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        stan::model::rvalue(psy_i, stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), "psy_i"), 
                        "assigning variable pp");
            current_statement_begin__ = 190;
            for (int ncell = 1; ncell <= nNotSampled; ++ncell) {

                current_statement_begin__ = 191;
                stan::math::assign(cell, get_base1(notSampledId,ncell,"notSampledId",1));
                current_statement_begin__ = 192;
                stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__));
            }
            current_statement_begin__ = 196;
            stan::math::assign(psy, (sum(cellpres_i) / n));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
        }
        check_greater_or_equal(function__,"cell",cell,1);
        check_greater_or_equal(function__,"psy",psy,0);
        check_less_or_equal(function__,"psy",psy,1);
        for (int k0__ = 0; k0__ < n; ++k0__) {
            check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
            check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
            check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
        }
        check_greater_or_equal(function__,"pp",pp,0);
        check_less_or_equal(function__,"pp",pp,1);

        // write generated quantities
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
        }
        vars__.push_back(cell);
        vars__.push_back(psy);
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(pp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
        }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psyipiq_CAR";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p_raw" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 3; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmax";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pmin";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "pRange";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_psyipq_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psyipq");
    reader.add_event(115, 115, "end", "model_psyipq");
    return reader;
}

class model_psyipq : public prob_grad {
private:
    int nSampledCells;
    vector<int> N;
    vector<int> y;
    double minP;
public:
    model_psyipq(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psyipq(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psyipq_namespace::model_psyipq";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
        nSampledCells = int(0);
        vals_i__ = context__.vals_i("nSampledCells");
        pos__ = 0;
        nSampledCells = vals_i__[pos__++];
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        N = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        y = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
        minP = double(0);
        vals_r__ = context__.vals_r("minP");
        pos__ = 0;
        minP = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        check_greater_or_equal(function__,"minP",minP,0);
        check_less_or_equal(function__,"minP",minP,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        validate_non_negative_index("odds", "2", 2);
        num_params_r__ += 2;
    }

    ~model_psyipq() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psy_Sampled")))
            throw std::runtime_error("variable psy_Sampled missing");
        vals_r__ = context__.vals_r("psy_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psy_Sampled", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration psy_Sampled
        vector_d psy_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psy_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "2", 2);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(2));
        // generate_declaration odds
        vector_d odds(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_Sampled;
        (void) psy_Sampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
        (void) odds;  // dummy to suppress unused var warning
        if (jacobian__)
            odds = in__.ordered_constrain(2,lp__);
        else
            odds = in__.ordered_constrain(2);


        // transformed parameters
        T__ q;
        (void) q;  // dummy to suppress unused var warning

        stan::math::initialize(q, DUMMY_VAR__);
        stan::math::fill(q,DUMMY_VAR__);
        T__ p;
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, DUMMY_VAR__);
        stan::math::fill(p,DUMMY_VAR__);
        T__ qRate;
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, DUMMY_VAR__);
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, DUMMY_VAR__);
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 25;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 26;
            stan::math::assign(p, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 27;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 29;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        if (stan::math::is_uninitialized(q)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: q";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(p)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: p";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(qRate)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: qRate";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"p",p,minP);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // model body
        try {

            current_statement_begin__ = 45;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 47;
            lp_accum__.add(beta_log(psy_Sampled,0.5,0.5));
            current_statement_begin__ = 49;
            lp_accum__.add(lLh_cell);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psy_Sampled");
        names__.push_back("odds");
        names__.push_back("q");
        names__.push_back("p");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("psy");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psyipq_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d odds = in__.ordered_constrain(2);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psy_Sampled[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(odds[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        double q(0.0);
        (void) q;  // dummy to suppress unused var warning

        stan::math::initialize(q, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(q,DUMMY_VAR__);
        double p(0.0);
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);
        double qRate(0.0);
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 25;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 26;
            stan::math::assign(p, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 27;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 29;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"p",p,minP);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // write transformed parameters
        vars__.push_back(q);
        vars__.push_back(p);
        vars__.push_back(qRate);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
        vector<int> sim_y(nSampledCells, 0);
        stan::math::fill(sim_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
        vector<int> sim_true_y(nSampledCells, 0);
        stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
        vector<int> sim_false_y(nSampledCells, 0);
        stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
        double psy(0.0);
        (void) psy;  // dummy to suppress unused var warning

        stan::math::initialize(psy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy,DUMMY_VAR__);
        validate_non_negative_index("cellpres_i", "nSampledCells", nSampledCells);
        vector<double> cellpres_i(nSampledCells, 0.0);
        stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cellpres_i,DUMMY_VAR__);
        validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
        vector<double> pCorr(nSampledCells, 0.0);
        stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pCorr,DUMMY_VAR__);
        validate_non_negative_index("pp", "nSampledCells", nSampledCells);
        vector_d pp(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) pp;  // dummy to suppress unused var warning

        stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pp,DUMMY_VAR__);
        validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
        vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) expRec;  // dummy to suppress unused var warning

        stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(expRec,DUMMY_VAR__);
        double chi_sq(0.0);
        (void) chi_sq;  // dummy to suppress unused var warning

        stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(chi_sq,DUMMY_VAR__);
        double npars(0.0);
        (void) npars;  // dummy to suppress unused var warning

        stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(npars,DUMMY_VAR__);
        double lLh(0.0);
        (void) lLh;  // dummy to suppress unused var warning

        stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh,DUMMY_VAR__);
        double AIC(0.0);
        (void) AIC;  // dummy to suppress unused var warning

        stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AIC,DUMMY_VAR__);
        double AICc(0.0);
        (void) AICc;  // dummy to suppress unused var warning

        stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AICc,DUMMY_VAR__);
        double bAIC(0.0);
        (void) bAIC;  // dummy to suppress unused var warning

        stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bAIC,DUMMY_VAR__);


        try {
            current_statement_begin__ = 74;
            stan::math::assign(npars, (nSampledCells + 2));
            current_statement_begin__ = 77;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 78;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 79;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 80;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 83;
            stan::math::assign(expRec, add(multiply(elt_multiply(psy_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psy_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 84;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 87;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 89;
                stan::math::assign(get_base1_lhs(pp,ncell,"pp",1), exp(((log(get_base1(psy_Sampled,ncell,"psy_Sampled",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p)) - log_mix(get_base1(psy_Sampled,ncell,"psy_Sampled",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 95;
                if (as_bool(bernoulli_rng(get_base1(pp,ncell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 96;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 1);
                    current_statement_begin__ = 97;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), p);
                    current_statement_begin__ = 98;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),p, base_rng__));
                    current_statement_begin__ = 99;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 102;
                    stan::math::assign(get_base1_lhs(cellpres_i,ncell,"cellpres_i",1), 0);
                    current_statement_begin__ = 103;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 104;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 105;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 108;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 112;
            stan::math::assign(psy, (sum(cellpres_i) / nSampledCells));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
        }
        check_greater_or_equal(function__,"psy",psy,0);
        check_less_or_equal(function__,"psy",psy,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
            check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
            check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
        }
        check_greater_or_equal(function__,"pp",pp,0);
        check_less_or_equal(function__,"pp",pp,1);

        // write generated quantities
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
        }
        vars__.push_back(psy);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
        }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psyipq";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




// Code generated by Stan version 2.16.0

#include <stan/model/model_header.hpp>

namespace model_psyipq_CAR_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_psyipq_CAR");
    reader.add_event(180, 180, "end", "model_psyipq_CAR");
    return reader;
}

template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
            validate_non_negative_index("phit_D", "n", n);
            Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_D(static_cast<Eigen::VectorXd::Index>(n));
            (void) phit_D;  // dummy to suppress unused var warning

            stan::math::initialize(phit_D, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(phit_D,DUMMY_VAR__);
            validate_non_negative_index("phit_W", "n", n);
            Eigen::Matrix<fun_scalar_t__,1,Eigen::Dynamic>  phit_W(static_cast<Eigen::VectorXd::Index>(n));
            (void) phit_W;  // dummy to suppress unused var warning

            stan::math::initialize(phit_W, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(phit_W,DUMMY_VAR__);
            validate_non_negative_index("ldet_terms", "n", n);
            Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  ldet_terms(static_cast<Eigen::VectorXd::Index>(n));
            (void) ldet_terms;  // dummy to suppress unused var warning

            stan::math::initialize(ldet_terms, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ldet_terms,DUMMY_VAR__);


            current_statement_begin__ = 24;
            stan::math::assign(phit_D, transpose(elt_multiply(phi,D_sparse)));
            current_statement_begin__ = 25;
            stan::math::assign(phit_W, rep_row_vector(0,n));
            current_statement_begin__ = 26;
            for (int i = 1; i <= W_n; ++i) {

                current_statement_begin__ = 27;
                stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phi",1)));
                current_statement_begin__ = 28;
                stan::math::assign(get_base1_lhs(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1), (get_base1(phit_W,get_base1(get_base1(W_sparse,i,"W_sparse",1),2,"W_sparse",2),"phit_W",1) + get_base1(phi,get_base1(get_base1(W_sparse,i,"W_sparse",1),1,"W_sparse",2),"phi",1)));
            }
            current_statement_begin__ = 31;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 31;
                stan::math::assign(get_base1_lhs(ldet_terms,i,"ldet_terms",1), log1m((alpha * get_base1(lambda,i,"lambda",1))));
            }
            current_statement_begin__ = 32;
            return stan::math::promote_scalar<fun_return_scalar_t__>((0.5 * (((n * log(tau)) + sum(ldet_terms)) - (tau * (multiply(phit_D,phi) - (alpha * multiply(phit_W,phi)))))));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
template <typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
sparse_car_lpdf(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) {
    return sparse_car_lpdf<false>(phi,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__);
}


struct sparse_car_lpdf_functor__ {
    template <bool propto, typename T0__, typename T1__, typename T2__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__, T4__, typename boost::math::tools::promote_args<T5__>::type>::type
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic,1>& phi,
                    const T1__& tau,
                    const T2__& alpha,
                    const std::vector<std::vector<int> >& W_sparse,
                    const Eigen::Matrix<T4__, Eigen::Dynamic,1>& D_sparse,
                    const Eigen::Matrix<T5__, Eigen::Dynamic,1>& lambda,
                    const int& n,
                    const int& W_n, std::ostream* pstream__) const {
        return sparse_car_lpdf(phi, tau, alpha, W_sparse, D_sparse, lambda, n, W_n, pstream__);
    }
};

class model_psyipq_CAR : public prob_grad {
private:
    int nSampledCells;
    vector<int> sampledId;
    int nNotSampled;
    vector<int> notSampledId;
    int n;
    int W_n;
    vector<vector<int> > W_sparse;
    vector_d D_sparse;
    vector_d lambda;
    vector<int> N;
    vector<int> y;
    double minP;
public:
    model_psyipq_CAR(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_psyipq_CAR(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_psyipq_CAR_namespace::model_psyipq_CAR";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "nSampledCells", "int", context__.to_vec());
        nSampledCells = int(0);
        vals_i__ = context__.vals_i("nSampledCells");
        pos__ = 0;
        nSampledCells = vals_i__[pos__++];
        validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "sampledId", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("sampledId", "nSampledCells", nSampledCells);
        sampledId = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("sampledId");
        pos__ = 0;
        size_t sampledId_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < sampledId_limit_0__; ++i_0__) {
            sampledId[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "nNotSampled", "int", context__.to_vec());
        nNotSampled = int(0);
        vals_i__ = context__.vals_i("nNotSampled");
        pos__ = 0;
        nNotSampled = vals_i__[pos__++];
        validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
        context__.validate_dims("data initialization", "notSampledId", "int", context__.to_vec(nNotSampled));
        validate_non_negative_index("notSampledId", "nNotSampled", nNotSampled);
        notSampledId = std::vector<int>(nNotSampled,int(0));
        vals_i__ = context__.vals_i("notSampledId");
        pos__ = 0;
        size_t notSampledId_limit_0__ = nNotSampled;
        for (size_t i_0__ = 0; i_0__ < notSampledId_limit_0__; ++i_0__) {
            notSampledId[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "n", "int", context__.to_vec());
        n = int(0);
        vals_i__ = context__.vals_i("n");
        pos__ = 0;
        n = vals_i__[pos__++];
        context__.validate_dims("data initialization", "W_n", "int", context__.to_vec());
        W_n = int(0);
        vals_i__ = context__.vals_i("W_n");
        pos__ = 0;
        W_n = vals_i__[pos__++];
        validate_non_negative_index("W_sparse", "W_n", W_n);
        validate_non_negative_index("W_sparse", "2", 2);
        context__.validate_dims("data initialization", "W_sparse", "int", context__.to_vec(W_n,2));
        validate_non_negative_index("W_sparse", "W_n", W_n);
        validate_non_negative_index("W_sparse", "2", 2);
        W_sparse = std::vector<std::vector<int> >(W_n,std::vector<int>(2,int(0)));
        vals_i__ = context__.vals_i("W_sparse");
        pos__ = 0;
        size_t W_sparse_limit_1__ = 2;
        for (size_t i_1__ = 0; i_1__ < W_sparse_limit_1__; ++i_1__) {
            size_t W_sparse_limit_0__ = W_n;
            for (size_t i_0__ = 0; i_0__ < W_sparse_limit_0__; ++i_0__) {
                W_sparse[i_0__][i_1__] = vals_i__[pos__++];
            }
        }
        validate_non_negative_index("D_sparse", "n", n);
        context__.validate_dims("data initialization", "D_sparse", "vector_d", context__.to_vec(n));
        validate_non_negative_index("D_sparse", "n", n);
        D_sparse = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("D_sparse");
        pos__ = 0;
        size_t D_sparse_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < D_sparse_i_vec_lim__; ++i_vec__) {
            D_sparse[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("lambda", "n", n);
        context__.validate_dims("data initialization", "lambda", "vector_d", context__.to_vec(n));
        validate_non_negative_index("lambda", "n", n);
        lambda = vector_d(static_cast<Eigen::VectorXd::Index>(n));
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0;
        size_t lambda_i_vec_lim__ = n;
        for (size_t i_vec__ = 0; i_vec__ < lambda_i_vec_lim__; ++i_vec__) {
            lambda[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "N", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("N", "nSampledCells", nSampledCells);
        N = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("N");
        pos__ = 0;
        size_t N_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < N_limit_0__; ++i_0__) {
            N[i_0__] = vals_i__[pos__++];
        }
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        context__.validate_dims("data initialization", "y", "int", context__.to_vec(nSampledCells));
        validate_non_negative_index("y", "nSampledCells", nSampledCells);
        y = std::vector<int>(nSampledCells,int(0));
        vals_i__ = context__.vals_i("y");
        pos__ = 0;
        size_t y_limit_0__ = nSampledCells;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "minP", "double", context__.to_vec());
        minP = double(0);
        vals_r__ = context__.vals_r("minP");
        pos__ = 0;
        minP = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"nSampledCells",nSampledCells,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sampledId[k0__]",sampledId[k0__],1);
        }
        check_greater_or_equal(function__,"nNotSampled",nNotSampled,0);
        for (int k0__ = 0; k0__ < nNotSampled; ++k0__) {
            check_greater_or_equal(function__,"notSampledId[k0__]",notSampledId[k0__],1);
        }
        check_greater_or_equal(function__,"n",n,1);
        check_greater_or_equal(function__,"W_n",W_n,1);
        for (int k0__ = 0; k0__ < W_n; ++k0__) {
            for (int k1__ = 0; k1__ < 2; ++k1__) {
                check_greater_or_equal(function__,"W_sparse[k0__][k1__]",W_sparse[k0__][k1__],1);
            }
        }
        check_greater_or_equal(function__,"D_sparse",D_sparse,1);
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"N[k0__]",N[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"y[k0__]",y[k0__],0);
        }
        check_greater_or_equal(function__,"minP",minP,0);
        check_less_or_equal(function__,"minP",minP,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        num_params_r__ += nSampledCells;
        validate_non_negative_index("psy_NotSampled", "nNotSampled", nNotSampled);
        num_params_r__ += nNotSampled;
        ++num_params_r__;
        ++num_params_r__;
        validate_non_negative_index("odds", "2", 2);
        num_params_r__ += 2;
    }

    ~model_psyipq_CAR() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("psy_Sampled")))
            throw std::runtime_error("variable psy_Sampled missing");
        vals_r__ = context__.vals_r("psy_Sampled");
        pos__ = 0U;
        validate_non_negative_index("psy_Sampled", "nSampledCells", nSampledCells);
        context__.validate_dims("initialization", "psy_Sampled", "vector_d", context__.to_vec(nSampledCells));
        // generate_declaration psy_Sampled
        vector_d psy_Sampled(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        for (int j1__ = 0U; j1__ < nSampledCells; ++j1__)
            psy_Sampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_Sampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_Sampled: ") + e.what());
        }

        if (!(context__.contains_r("psy_NotSampled")))
            throw std::runtime_error("variable psy_NotSampled missing");
        vals_r__ = context__.vals_r("psy_NotSampled");
        pos__ = 0U;
        validate_non_negative_index("psy_NotSampled", "nNotSampled", nNotSampled);
        context__.validate_dims("initialization", "psy_NotSampled", "vector_d", context__.to_vec(nNotSampled));
        // generate_declaration psy_NotSampled
        vector_d psy_NotSampled(static_cast<Eigen::VectorXd::Index>(nNotSampled));
        for (int j1__ = 0U; j1__ < nNotSampled; ++j1__)
            psy_NotSampled(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,psy_NotSampled);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psy_NotSampled: ") + e.what());
        }

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        // generate_declaration tau
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        // generate_declaration alpha
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("odds")))
            throw std::runtime_error("variable odds missing");
        vals_r__ = context__.vals_r("odds");
        pos__ = 0U;
        validate_non_negative_index("odds", "2", 2);
        context__.validate_dims("initialization", "odds", "vector_d", context__.to_vec(2));
        // generate_declaration odds
        vector_d odds(static_cast<Eigen::VectorXd::Index>(2));
        for (int j1__ = 0U; j1__ < 2; ++j1__)
            odds(j1__) = vals_r__[pos__++];
        try {
            writer__.ordered_unconstrain(odds);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable odds: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_Sampled;
        (void) psy_Sampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells,lp__);
        else
            psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_NotSampled;
        (void) psy_NotSampled;  // dummy to suppress unused var warning
        if (jacobian__)
            psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled,lp__);
        else
            psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);

        T__ tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.scalar_lb_constrain(0,lp__);
        else
            tau = in__.scalar_lb_constrain(0);

        T__ alpha;
        (void) alpha;  // dummy to suppress unused var warning
        if (jacobian__)
            alpha = in__.scalar_lub_constrain(0,1,lp__);
        else
            alpha = in__.scalar_lub_constrain(0,1);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  odds;
        (void) odds;  // dummy to suppress unused var warning
        if (jacobian__)
            odds = in__.ordered_constrain(2,lp__);
        else
            odds = in__.ordered_constrain(2);


        // transformed parameters
        validate_non_negative_index("psy_i", "n", n);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  psy_i(static_cast<Eigen::VectorXd::Index>(n));
        (void) psy_i;  // dummy to suppress unused var warning

        stan::math::initialize(psy_i, DUMMY_VAR__);
        stan::math::fill(psy_i,DUMMY_VAR__);
        T__ q;
        (void) q;  // dummy to suppress unused var warning

        stan::math::initialize(q, DUMMY_VAR__);
        stan::math::fill(q,DUMMY_VAR__);
        T__ p;
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, DUMMY_VAR__);
        stan::math::fill(p,DUMMY_VAR__);
        T__ qRate;
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, DUMMY_VAR__);
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, DUMMY_VAR__);
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 77;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psy_Sampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 78;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psy_NotSampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 79;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 80;
            stan::math::assign(p, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 81;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 83;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 85;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < n; ++i0__) {
            if (stan::math::is_uninitialized(psy_i(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: psy_i" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(q)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: q";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(p)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: p";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(qRate)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: qRate";
            throw std::runtime_error(msg__.str());
        }
        for (int i0__ = 0; i0__ < nSampledCells; ++i0__) {
            if (stan::math::is_uninitialized(lLh_cell(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lLh_cell" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"psy_i",psy_i,0);
        check_less_or_equal(function__,"psy_i",psy_i,1);
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"p",p,minP);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // model body
        try {

            current_statement_begin__ = 99;
            lp_accum__.add(normal_log(qRate,0,0.050000000000000003));
            current_statement_begin__ = 100;
            lp_accum__.add(beta_log(psy_i,0.5,0.5));
            current_statement_begin__ = 101;
            lp_accum__.add(gamma_log(tau,2,2));
            current_statement_begin__ = 104;
            lp_accum__.add(lLh_cell);
            current_statement_begin__ = 106;
            lp_accum__.add(sparse_car_lpdf(psy_i,tau,alpha,W_sparse,D_sparse,lambda,n,W_n, pstream__));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psy_Sampled");
        names__.push_back("psy_NotSampled");
        names__.push_back("tau");
        names__.push_back("alpha");
        names__.push_back("odds");
        names__.push_back("psy_i");
        names__.push_back("q");
        names__.push_back("p");
        names__.push_back("qRate");
        names__.push_back("lLh_cell");
        names__.push_back("sim_y");
        names__.push_back("sim_true_y");
        names__.push_back("sim_false_y");
        names__.push_back("cell");
        names__.push_back("psy");
        names__.push_back("cellpres_i");
        names__.push_back("pCorr");
        names__.push_back("pp");
        names__.push_back("expRec");
        names__.push_back("chi_sq");
        names__.push_back("npars");
        names__.push_back("lLh");
        names__.push_back("AIC");
        names__.push_back("AICc");
        names__.push_back("bAIC");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nNotSampled);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nSampledCells);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_psyipq_CAR_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d psy_Sampled = in__.vector_lub_constrain(0,1,nSampledCells);
        vector_d psy_NotSampled = in__.vector_lub_constrain(0,1,nNotSampled);
        double tau = in__.scalar_lb_constrain(0);
        double alpha = in__.scalar_lub_constrain(0,1);
        vector_d odds = in__.ordered_constrain(2);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(psy_Sampled[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nNotSampled; ++k_0__) {
            vars__.push_back(psy_NotSampled[k_0__]);
        }
        vars__.push_back(tau);
        vars__.push_back(alpha);
        for (int k_0__ = 0; k_0__ < 2; ++k_0__) {
            vars__.push_back(odds[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("psy_i", "n", n);
        vector_d psy_i(static_cast<Eigen::VectorXd::Index>(n));
        (void) psy_i;  // dummy to suppress unused var warning

        stan::math::initialize(psy_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy_i,DUMMY_VAR__);
        double q(0.0);
        (void) q;  // dummy to suppress unused var warning

        stan::math::initialize(q, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(q,DUMMY_VAR__);
        double p(0.0);
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);
        double qRate(0.0);
        (void) qRate;  // dummy to suppress unused var warning

        stan::math::initialize(qRate, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(qRate,DUMMY_VAR__);
        validate_non_negative_index("lLh_cell", "nSampledCells", nSampledCells);
        vector_d lLh_cell(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) lLh_cell;  // dummy to suppress unused var warning

        stan::math::initialize(lLh_cell, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh_cell,DUMMY_VAR__);


        try {
            current_statement_begin__ = 77;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(sampledId), stan::model::nil_index_list()), 
                        psy_Sampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 78;
            stan::model::assign(psy_i, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        psy_NotSampled, 
                        "assigning variable psy_i");
            current_statement_begin__ = 79;
            stan::math::assign(q, inv_logit(get_base1(odds,1,"odds",1)));
            current_statement_begin__ = 80;
            stan::math::assign(p, inv_logit(get_base1(odds,2,"odds",1)));
            current_statement_begin__ = 81;
            stan::math::assign(qRate, (q / p));
            current_statement_begin__ = 83;
            for (int cell = 1; cell <= nSampledCells; ++cell) {

                current_statement_begin__ = 85;
                stan::math::assign(get_base1_lhs(lLh_cell,cell,"lLh_cell",1), log_mix(get_base1(psy_Sampled,cell,"psy_Sampled",1),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),p),binomial_log(get_base1(y,cell,"y",1),get_base1(N,cell,"N",1),q)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"psy_i",psy_i,0);
        check_less_or_equal(function__,"psy_i",psy_i,1);
        check_greater_or_equal(function__,"q",q,0);
        check_less_or_equal(function__,"q",q,1);
        check_greater_or_equal(function__,"p",p,minP);
        check_less_or_equal(function__,"p",p,1);
        check_greater_or_equal(function__,"qRate",qRate,0);
        check_less_or_equal(function__,"qRate",qRate,1);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(psy_i[k_0__]);
        }
        vars__.push_back(q);
        vars__.push_back(p);
        vars__.push_back(qRate);
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(lLh_cell[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("sim_y", "nSampledCells", nSampledCells);
        vector<int> sim_y(nSampledCells, 0);
        stan::math::fill(sim_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_true_y", "nSampledCells", nSampledCells);
        vector<int> sim_true_y(nSampledCells, 0);
        stan::math::fill(sim_true_y, std::numeric_limits<int>::min());
        validate_non_negative_index("sim_false_y", "nSampledCells", nSampledCells);
        vector<int> sim_false_y(nSampledCells, 0);
        stan::math::fill(sim_false_y, std::numeric_limits<int>::min());
        int cell(0);
        (void) cell;  // dummy to suppress unused var warning

        stan::math::fill(cell, std::numeric_limits<int>::min());
        double psy(0.0);
        (void) psy;  // dummy to suppress unused var warning

        stan::math::initialize(psy, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(psy,DUMMY_VAR__);
        validate_non_negative_index("cellpres_i", "n", n);
        vector<double> cellpres_i(n, 0.0);
        stan::math::initialize(cellpres_i, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(cellpres_i,DUMMY_VAR__);
        validate_non_negative_index("pCorr", "nSampledCells", nSampledCells);
        vector<double> pCorr(nSampledCells, 0.0);
        stan::math::initialize(pCorr, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pCorr,DUMMY_VAR__);
        validate_non_negative_index("pp", "n", n);
        vector_d pp(static_cast<Eigen::VectorXd::Index>(n));
        (void) pp;  // dummy to suppress unused var warning

        stan::math::initialize(pp, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(pp,DUMMY_VAR__);
        validate_non_negative_index("expRec", "nSampledCells", nSampledCells);
        vector_d expRec(static_cast<Eigen::VectorXd::Index>(nSampledCells));
        (void) expRec;  // dummy to suppress unused var warning

        stan::math::initialize(expRec, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(expRec,DUMMY_VAR__);
        double chi_sq(0.0);
        (void) chi_sq;  // dummy to suppress unused var warning

        stan::math::initialize(chi_sq, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(chi_sq,DUMMY_VAR__);
        double npars(0.0);
        (void) npars;  // dummy to suppress unused var warning

        stan::math::initialize(npars, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(npars,DUMMY_VAR__);
        double lLh(0.0);
        (void) lLh;  // dummy to suppress unused var warning

        stan::math::initialize(lLh, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(lLh,DUMMY_VAR__);
        double AIC(0.0);
        (void) AIC;  // dummy to suppress unused var warning

        stan::math::initialize(AIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AIC,DUMMY_VAR__);
        double AICc(0.0);
        (void) AICc;  // dummy to suppress unused var warning

        stan::math::initialize(AICc, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(AICc,DUMMY_VAR__);
        double bAIC(0.0);
        (void) bAIC;  // dummy to suppress unused var warning

        stan::math::initialize(bAIC, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bAIC,DUMMY_VAR__);


        try {
            current_statement_begin__ = 131;
            stan::math::assign(npars, ((((nSampledCells + nNotSampled) + 1) + 1) + 2));
            current_statement_begin__ = 134;
            stan::math::assign(lLh, sum(lLh_cell));
            current_statement_begin__ = 135;
            stan::math::assign(AIC, ((2 * npars) - (2 * lLh)));
            current_statement_begin__ = 136;
            stan::math::assign(AICc, (AIC + (((2 * npars) * (npars + 1)) / ((nSampledCells - npars) - 1))));
            current_statement_begin__ = 137;
            stan::math::assign(bAIC, ((log(nSampledCells) * npars) - (2 * lLh)));
            current_statement_begin__ = 139;
            stan::math::assign(expRec, add(multiply(elt_multiply(psy_Sampled,to_vector(N)),p),multiply(elt_multiply(subtract(1,psy_Sampled),to_vector(N)),q)));
            current_statement_begin__ = 140;
            stan::math::assign(chi_sq, sum(elt_divide(elt_multiply(subtract(expRec,to_vector(y)),subtract(expRec,to_vector(y))),expRec)));
            current_statement_begin__ = 143;
            for (int ncell = 1; ncell <= nSampledCells; ++ncell) {

                current_statement_begin__ = 145;
                stan::math::assign(cell, get_base1(sampledId,ncell,"sampledId",1));
                current_statement_begin__ = 146;
                stan::math::assign(get_base1_lhs(pp,cell,"pp",1), exp(((log(get_base1(psy_i,cell,"psy_i",1)) + binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p)) - log_mix(get_base1(psy_i,cell,"psy_i",1),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),p),binomial_log(get_base1(y,ncell,"y",1),get_base1(N,ncell,"N",1),q)))));
                current_statement_begin__ = 152;
                if (as_bool(bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__))) {

                    current_statement_begin__ = 153;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 1);
                    current_statement_begin__ = 154;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), p);
                    current_statement_begin__ = 155;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), binomial_rng(get_base1(N,ncell,"N",1),p, base_rng__));
                    current_statement_begin__ = 156;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), 0);
                } else {

                    current_statement_begin__ = 159;
                    stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), 0);
                    current_statement_begin__ = 160;
                    stan::math::assign(get_base1_lhs(pCorr,ncell,"pCorr",1), 0);
                    current_statement_begin__ = 161;
                    stan::math::assign(get_base1_lhs(sim_true_y,ncell,"sim_true_y",1), 0);
                    current_statement_begin__ = 162;
                    stan::math::assign(get_base1_lhs(sim_false_y,ncell,"sim_false_y",1), binomial_rng(get_base1(N,ncell,"N",1),q, base_rng__));
                }
                current_statement_begin__ = 165;
                stan::math::assign(get_base1_lhs(sim_y,ncell,"sim_y",1), (get_base1(sim_true_y,ncell,"sim_true_y",1) + get_base1(sim_false_y,ncell,"sim_false_y",1)));
            }
            current_statement_begin__ = 169;
            stan::model::assign(pp, 
                        stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), 
                        stan::model::rvalue(psy_i, stan::model::cons_list(stan::model::index_multi(notSampledId), stan::model::nil_index_list()), "psy_i"), 
                        "assigning variable pp");
            current_statement_begin__ = 171;
            for (int ncell = 1; ncell <= nNotSampled; ++ncell) {

                current_statement_begin__ = 172;
                stan::math::assign(cell, get_base1(notSampledId,ncell,"notSampledId",1));
                current_statement_begin__ = 173;
                stan::math::assign(get_base1_lhs(cellpres_i,cell,"cellpres_i",1), bernoulli_rng(get_base1(pp,cell,"pp",1), base_rng__));
            }
            current_statement_begin__ = 177;
            stan::math::assign(psy, (sum(cellpres_i) / n));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_y[k0__]",sim_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_true_y[k0__]",sim_true_y[k0__],0);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"sim_false_y[k0__]",sim_false_y[k0__],0);
        }
        check_greater_or_equal(function__,"cell",cell,1);
        check_greater_or_equal(function__,"psy",psy,0);
        check_less_or_equal(function__,"psy",psy,1);
        for (int k0__ = 0; k0__ < n; ++k0__) {
            check_greater_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],0);
            check_less_or_equal(function__,"cellpres_i[k0__]",cellpres_i[k0__],1);
        }
        for (int k0__ = 0; k0__ < nSampledCells; ++k0__) {
            check_greater_or_equal(function__,"pCorr[k0__]",pCorr[k0__],0);
            check_less_or_equal(function__,"pCorr[k0__]",pCorr[k0__],1);
        }
        check_greater_or_equal(function__,"pp",pp,0);
        check_less_or_equal(function__,"pp",pp,1);

        // write generated quantities
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_true_y[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(sim_false_y[k_0__]);
        }
        vars__.push_back(cell);
        vars__.push_back(psy);
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(cellpres_i[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(pCorr[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < n; ++k_0__) {
            vars__.push_back(pp[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < nSampledCells; ++k_0__) {
            vars__.push_back(expRec[k_0__]);
        }
        vars__.push_back(chi_sq);
        vars__.push_back(npars);
        vars__.push_back(lLh);
        vars__.push_back(AIC);
        vars__.push_back(AICc);
        vars__.push_back(bAIC);

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_psyipq_CAR";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_Sampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nNotSampled; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_NotSampled" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= 2; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "odds" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psy_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "q";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "p";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "qRate";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lLh_cell" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_true_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sim_false_y" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "cell";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psy";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cellpres_i" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pCorr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pp" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nSampledCells; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "expRec" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "chi_sq";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "npars";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lLh";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AIC";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "AICc";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "bAIC";
        param_names__.push_back(param_name_stream__.str());
    }

}; // model

}




#endif
