\name{tfr.predict}
\Rdversion{1.1}
\alias{tfr.predict}
\alias{bayesTFR.prediction}

\title{
Generating Posterior Trajectories of the Total Fertility Rate
}
\description{
Using the posterior parameter samples simulated by \code{\link{run.tfr.mcmc}} the function  generates posterior trajectories for the total fertility rate for all countries of the world.
}
\usage{
tfr.predict(mcmc.set = NULL, end.year = 2100, 
    sim.dir = file.path(getwd(), "bayesTFR.output"), 
    replace.output = FALSE, nr.traj = NULL, thin = NULL,
    burnin = 2000, use.diagnostics = FALSE,
    save.as.ascii = 1000, output.dir = NULL,  
    low.memory = TRUE, 
    mu = 2.1, rho = 0.8859, sigmaAR1 = 0.1016,
    seed = NULL, verbose = TRUE)
}

\arguments{
  \item{mcmc.set}{Object of class \code{\link{bayesTFR.mcmc.set}}. If it is \code{NULL}, the object is loaded from the directory given by \code{sim.dir}.}
  \item{end.year}{End year of the prediction.}
  \item{sim.dir}{Directory with the MCMC simulation results. It should equal to the \code{output.dir} argument in \code{\link{run.tfr.mcmc}}.}
  \item{replace.output}{Logical. If \code{TRUE}, existing predictions in \code{output.dir} will be replaced by results of this run.}
  \item{nr.traj}{Number of trajectories to be generated. If \code{NULL}, the argument \code{thin} is taken to determine the number of trajectories. If both are \code{NULL}, the number of trajectories corresponds to the size of the parameter sample.}
  \item{thin}{Thinning interval used for determining the number of trajectories. Only relevant, if \code{nr.traj} is \code{NULL}.}
  \item{burnin}{Number of iterations to be discarded from the beginning of the parameter traces.}
  \item{use.diagnostics}{Logical determining if an existing convergence diagnostics should be used for choosing the values of \code{thin} and \code{burnin}. In such a case, arguments \code{nr.traj}, \code{thin} and \code{burnin} are ignored. The \sQuote{best} values are chosen from results of running the \code{\link{tfr.diagnose}} function. Only diagnostics can be used that suggest a convergence of the underlying MCMCs. If there are more than one such objects, the one is chosen whose recommendation for the number of trajectories is larger and closest to 2000.}
  \item{save.as.ascii}{Either a number determining how many trajectories should be converted into an ASCII file, or \dQuote{all} in which case all trajectories are converted. It should be set to 0, if no conversion is desired.}
  \item{output.dir}{Directory into which the resulting prediction object and the trajectories are stored. If it is \code{NULL}, it is set to either \code{sim.dir}, or to \code{output.dir} of \code{mcmc.set$meta} if \code{mcmc.set} is given.}
  \item{low.memory}{Logical indicating if the prediction should run in a low-memory mode. If it is \code{FALSE}, the whole traces of all parameters, including the burnin, are loaded into memory. Otherwise, burnins are discarded and parameters are loaded as they are needed and are not kept in the memory.}
  \item{mu}{Long-term mean \eqn{\mu}{mu} in the AR(1) projection model.}
  \item{rho}{Autoregressive parameter \eqn{\rho}{rho} in AR(1) projection model. If it is \code{NULL} it is estimated from the data.}
  \item{sigmaAR1}{Standard deviation \eqn{s} of AR(1) distortion terms in short-term projections. If it is \code{NULL} it is estimated from the data. It can be a single value or a vector giving the standard deviations for single projections. If the vector is shorter than the number of projections simulated via the AR(1) process, the last value is repeated for the remaining projections. In case of a single value (default), the standard deviation is kept constant over all AR(1) projections.}
  \item{seed}{Seed of the random number generator. If \code{NULL} no seed is set. It can be used to generate reproducible projections.}
  \item{verbose}{Logical switching log messages on and off.}
}
\details{
The trajectories are generated using the double logistic function (cite) and the AR(1) process.  Parameter samples  simulated using \code{\link{run.tfr.mcmc}} are used from all chains, from which the given burnin was discarded. They are evenly thinned to match \code{nr.traj} or using the \code{thin} argument. Such thinned parameter traces, collapsed into one chain, if they do not already exist, are stored on disk into the sub-directory \file{\{thinned_mcmc_\emph{t}_\emph{b}} where \emph{t} is the value  of \code{thin} and \emph{b} the value of \code{burnin} (see \code{\link{create.thinned.tfr.mcmc}}). 
	
The projection is run for all missing values before the present year, if any. Medians over the trajectories are used as  imputed values and the trajectories are discarded. The process then continues by projecting the future values where all generated trajectories are kept.

The resulting prediction object is saved into \file{\{output.dir\}/predictions}. Trajectories for all countries are saved into the same directory in a binary format, one file per country. At the end of the projection, if \code{save.as.ascii} is larger than 0, the function converts the given number of trajectories into a CSV file of a UN-specific format. They are selected by equal spacing (see function \code{\link{convert.tfr.trajectories}} for more details on the conversion). In addition, two summary files are created: one in a user-friendly format, the other using a UN-specific coding of the variants and time (see \code{\link{write.projection.summary}} for more details).
}

\value{
	Object of class \code{bayesTFR.prediction} which is a list containing components:
	\item{quantiles}{A \eqn{n \times q \times p}{n x q x p} array of quantile values computed on all trajectories. \eqn{n} is the number of countries,
		\eqn{q} is the number of quantile bounds and \eqn{p} is the number of projections.}
	\item{traj.mean.sd}{A \eqn{n \times 2 \times p}{n x 2 x p} array holding the mean of all trajectories in the first column and the standard deviation in the second column.
		\eqn{n} and \eqn{p} are the number of countries and number of projections, respectively.}
	\item{nr.traj}{Number of trajectories.}
	\item{trf_matrix_reconstructed}{Matrix containing imputed TFR values on spots where the original TFR matrix has missing values, i.e. between the last observed data point and the present year. }
	\item{output.directory}{Directory where trajectories corresponding to this prediction are stored.}
	\item{nr.projections}{Number of projections.}
	\item{burnin}{Burnin used for this prediction.}
	\item{end.year}{The end year of this prediction.}
	\item{mu, rho, sigma_t, sigmaAR1}{Parameters of the AR(1) process. \code{sigma_t} is a vector of actual values of the standard deviation \eqn{s} used for each projection.}
	\item{na.index}{Index of trajectories for which at least one country got \code{NA} values.}
	\item{mcmc.set}{Object of class \code{\link{bayesTFR.mcmc.set}} used for this prediction, i.e. the burned, thinned, and collapsed MCMC chain.}
	}
	
\references{
L. Alkema, A. E. Raftery, P. Gerland, S. J. Clark, F. Pelletier, T. Buettner: 
Probabilistic projections of the total fertility rate for all countries. Working Paper nr. 97, Center for Statistics and the Social Sciences, University of Washington. \url{http://www.csss.washington.edu/Papers}
}
\author{
Hana Sevcikova, Leontine Alkema
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{run.tfr.mcmc}}, \code{\link{create.thinned.tfr.mcmc}}, \code{\link{convert.tfr.trajectories}}, \code{\link{write.projection.summary}},    
\code{\link{get.tfr.prediction}}, \code{\link{summary.bayesTFR.prediction}}
}
\examples{
\dontrun{
m <- run.tfr.mcmc(nr.chains=1, iter=10, verbose=TRUE)
pred <- tfr.predict(m, burnin=0, verbose=TRUE)
summary(pred, country='Iceland')
}
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{distribution}
\keyword{multivariate}
