% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_bayescopulaglm.R
\name{predict.bayescopulaglm}
\alias{predict.bayescopulaglm}
\title{Predictive posterior sample from copula GLM}
\usage{
\method{predict}{bayescopulaglm}(object, newdata, nsims = 1, ...)
}
\arguments{
\item{object}{Result from calling \code{bayescopulaglm}}

\item{newdata}{\code{data.frame} of new data}

\item{nsims}{number of posterior draws to take. The default and minimum is 1. The maximum is the number of simulations in \code{object}}

\item{...}{further arguments passed to or from other methods}
}
\value{
\code{array} of dimension \code{c(n, J, nsims)} of predicted values, where \code{J} is the number of endpoints
}
\description{
Sample from the predictive posterior density of a copula generalized linear model regression
}
\examples{
set.seed(1234)
n <- 100
M <- 1000

x <- runif(n, 1, 2)
y1 <- 0.25 * x + rnorm(100)
y2 <- rpois(n, exp(0.25 * x))

formula.list <- list(y1 ~ 0 + x, y2 ~ 0 + x)
family.list <- list(gaussian(), poisson())
data = data.frame(y1, y2, x)

## Perform copula regression sampling with default
## (noninformative) priors
sample <- bayescopulaglm(
  formula.list, family.list, data, M = M
)
predict(sample, newdata = data)

}
