% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trends.R
\name{plot_trends}
\alias{plot_trends}
\title{Plot the trends from a DFA}
\usage{
plot_trends(
  rotated_modelfit,
  years = NULL,
  highlight_outliers = FALSE,
  threshold = 0.01
)
}
\arguments{
\item{rotated_modelfit}{Output from \code{\link{rotate_trends}}}

\item{years}{Optional numeric vector of years for the plot}

\item{highlight_outliers}{Logical. Should trend events
that exceed the probability of occurring with a normal distribution as
defined by \code{threshold} be highlighted? Defaults to FALSE}

\item{threshold}{A probability threshold below which to
flag trend events as extreme. Defaults to 0.01}
}
\description{
Plot the trends from a DFA
}
\examples{
set.seed(1)
s <- sim_dfa(num_trends = 1)
m <- fit_dfa(y = s$y_sim, num_trends = 1, iter = 50, chains = 1)
r <- rotate_trends(m)
p <- plot_trends(r)
print(p)
}
\seealso{
plot_loadings fit_dfa rotate_trends
}
