% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.lm_b}
\alias{plot.aov_b}
\alias{plot.lm_b_bma}
\alias{plot.glm_b}
\alias{plot.np_glm_b}
\alias{plot.mediate_b}
\alias{plot.survfit_b}
\title{Plots bayesics objects.}
\usage{
\method{plot}{lm_b}(
  x,
  type,
  variable,
  exemplar_covariates,
  combine_pred_cred = TRUE,
  variable_seq_length = 30,
  return_as_list = FALSE,
  CI_level = 0.95,
  PI_level = 0.95,
  backtransformation = function(x) {
     x
 },
  ...
)

\method{plot}{aov_b}(
  x,
  type = c("diagnostics", "cred band", "pred band"),
  combine_pred_cred = TRUE,
  return_as_list = FALSE,
  CI_level = 0.95,
  PI_level = 0.95,
  ...
)

\method{plot}{lm_b_bma}(
  x,
  type = c("diagnostics", "cred band", "pred band"),
  variable,
  exemplar_covariates,
  combine_pred_cred = TRUE,
  bayes_pvalues_quantiles = c(0.01, 1:19/20, 0.99),
  variable_seq_length = 30,
  return_as_list = FALSE,
  CI_level = 0.95,
  PI_level = 0.95,
  seed = 1,
  backtransformation = function(x) {
     x
 },
  ...
)

\method{plot}{glm_b}(
  x,
  type,
  variable,
  exemplar_covariates,
  combine_pred_cred = TRUE,
  variable_seq_length = 30,
  return_as_list = FALSE,
  CI_level = 0.95,
  PI_level = 0.95,
  seed = 1,
  ...
)

\method{plot}{np_glm_b}(
  x,
  type,
  variable,
  exemplar_covariates,
  variable_seq_length = 30,
  return_as_list = FALSE,
  CI_level = 0.95,
  seed = 1,
  backtransformation = function(x) {
     x
 },
  ...
)

\method{plot}{mediate_b}(x, type, return_as_list = FALSE, ...)

\method{plot}{survfit_b}(x, n_draws = 10000, seed = 1, CI_level = 0.95, ...)
}
\arguments{
\item{x}{A bayesics object}

\item{type}{character. Select any of "diagnostics" ("dx" is also allowed),
"pdp" (partial dependence plot), "cred band", and/or "pred band".
NOTE: the credible and prediction bands only work for numeric
variables.  If plotting a \code{mediate_b} object, the valid
values for \code{type} are "diagnostics" (or "dx"), "acme",
or "ade".}

\item{variable}{character. If type = "pdp" , which variable should be plotted?}

\item{exemplar_covariates}{data.frame or tibble with exactly one row.
Used to fix other covariates while varying the variable of interest for the plot.}

\item{combine_pred_cred}{logical. If type includes both "cred band" and "pred band",
should the credible band be superimposed on the prediction band or
plotted separately?}

\item{variable_seq_length}{integer. Number of points used to draw pdp.}

\item{return_as_list}{logical.  If TRUE, a list of ggplots will be returned,
rather than a single plot produced by the patchwork package.}

\item{CI_level}{Posterior probability covered by credible interval}

\item{PI_level}{Posterior probability covered by prediction interval}

\item{backtransformation}{function.  If a transformation of
the response variable was used, \code{backtransformation}
should be the inverse of this transformation function.  E.g.,
if you fit lm_b(log(y) ~ x), then set \code{backtransformation=exp}.}

\item{...}{optional arguments.}

\item{bayes_pvalues_quantiles}{ADD description!}

\item{seed}{ADD description!}

\item{n_draws}{integer.  Number of posterior draws used for visualization
of survival curves.  Ignored if \code{x} is not a \code{survfit_b} object.}
}
\value{
If \code{return_as_list=TRUE}, a list of requested ggplots.
}
\description{
Plots bayesics objects.
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data <-
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome <-
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )
fit1 <-
  lm_b(outcome ~ x1 + x2 + x3,
       data = test_data)
plot(fit1)
}


}
