% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_gibbs_sampler.R
\name{segment_behavior}
\alias{segment_behavior}
\title{Segmentation model to estimate breakpoints}
\usage{
segment_behavior(
  data,
  ngibbs,
  nbins,
  alpha,
  breakpt = purrr::map(names(data), ~NULL)
)
}
\arguments{
\item{data}{A list where each element stores the data for a separate animal
ID. List elements are data frames that only contain columns for the animal
ID and for each of the discretized movement variables.}

\item{ngibbs}{numeric. The total number of iterations of the MCMC chain.}

\item{nbins}{numeric. A vector of the number of bins used to discretize each
movement variable. These must be in the same order as the columns within
\code{data}.}

\item{alpha}{numeric. A single value used to specify the hyperparameter for
the prior distribution. A standard value for \code{alpha} is typically 1,
which corresponds with a vague prior on the Dirichlet distribution.}

\item{breakpt}{A list where each element stores a vector of breakpoints if
pre-specifying where they may occur for each animal ID. By default this is
set to \code{NULL}.}
}
\value{
A list of model results is returned where elements include the
  breakpoints, number of breakpoints, and log marginal likelihood at each
  iteration of the MCMC chain for all animal IDs. The time it took the model
  to finish running for each animal ID are also stored and returned.
}
\description{
This function performs the reversible-jump MCMC algorithm using a Gibbs
sampler, which estimates the breakpoints of the movement variables for each
of the animal IDs. This is the first stage of the two-stage Bayesian model that
estimates proportions of behavioral states by first segmenting individual
tracks into relatively homogeneous segments of movement.
}
\details{
This model is run in parallel using the \code{future} package. To ensure that
the model is run in parallel, the \code{\link[future]{plan}} must be used
with \code{future::multisession} as the argument for most operating systems.
Otherwise, model will run sequentially by default if this is not set before
running \code{segment_behavior}.
}
\examples{
\donttest{
#load data
data(tracks.list)

#subset only first track
tracks.list<- tracks.list[1]

#only retain id and discretized step length (SL) and turning angle (TA) columns
tracks.list2<- purrr::map(tracks.list,
                   subset,
                  select = c(id, SL, TA))


set.seed(1)

# Define model params
alpha<- 1
ngibbs<- 1000
nbins<- c(5,8)

future::plan(future::multisession)  #run all MCMC chains in parallel
dat.res<- segment_behavior(data = tracks.list2, ngibbs = ngibbs, nbins = nbins,
                           alpha = alpha)

future::plan(future::sequential)  #return to single core
}

}
