% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.bayesnecfit}
\alias{plot.bayesmanecfit}
\title{Generates a plot for objects fitted by \code{\link{bnec}}}
\usage{
\method{plot}{bayesnecfit}(
  x,
  ...,
  CI = TRUE,
  add_nec = TRUE,
  position_legend = "topright",
  add_ec10 = FALSE,
  xform = identity,
  lxform = identity,
  jitter_x = FALSE,
  jitter_y = FALSE,
  ylab = "Response",
  xlab = "Predictor",
  xticks = NA
)

\method{plot}{bayesmanecfit}(
  x,
  ...,
  CI = TRUE,
  add_nec = TRUE,
  position_legend = "topright",
  add_ec10 = FALSE,
  xform = identity,
  lxform = identity,
  jitter_x = FALSE,
  jitter_y = FALSE,
  ylab = "Response",
  xlab = "Predictor",
  xticks = NA,
  all_models = FALSE
)
}
\arguments{
\item{x}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.}

\item{...}{Additional arguments to \code{\link[graphics]{plot}}.}

\item{CI}{A \code{\link[base]{logical}} value indicating if credibility
intervals on the model fit should be plotted, calculated as the upper and
lower bounds of the individual predicted values from all posterior samples.}

\item{add_nec}{A \code{\link[base]{logical}} value indicating if the
estimated NEC value and 95\% credible intervals should be added to the plot.}

\item{position_legend}{A \code{\link[base]{numeric}} vector indicating the
location of the NEC or EC10 legend, as per a call to legend.}

\item{add_ec10}{A \code{\link[base]{logical}} value indicating if an
estimated EC10 value and 95\% credible intervals should be added to the plot.}

\item{xform}{A function to be applied as a transformation of the x data.}

\item{lxform}{A function to be applied as a transformation only to axis
labels and the annotated NEC / EC10 values.}

\item{jitter_x}{A \code{\link[base]{logical}} value indicating if the x
data points on the plot should be jittered.}

\item{jitter_y}{A \code{\link[base]{logical}} value indicating if the y
data points on the plot should be jittered.}

\item{ylab}{A \code{\link[base]{character}} vector to use for the y-axis
label.}

\item{xlab}{A \code{\link[base]{character}} vector to use for the x-axis
label.}

\item{xticks}{A numeric vector indicate where to place the tick marks of
the x-axis.}

\item{all_models}{A \code{\link[base]{logical}} value indicating if all
models in the model set should be plotted simultaneously, or if a model
average plot should be returned.}
}
\value{
A \code{\link[graphics]{plot}} of the fitted model.
}
\description{
Generates a plot for objects fitted by \code{\link{bnec}}.
\code{x} should be of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.
}
\examples{
\donttest{
library(bayesnec)
nec4param <- pull_out(manec_example, "nec4param")
# plot single models (bayesnecfit)
plot(nec4param)
plot(nec4param, add_nec = FALSE)
plot(nec4param, add_ec10 = TRUE)

# plot model averaged predictions (bayesmanecfit)
plot(manec_example)
# plot all panels together
plot(manec_example, add_ec10 = TRUE, all_models = TRUE)
}
}
