% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{formula}
\alias{formula}
\alias{formula.bayesnecfit}
\alias{formula.bayesmanecfit}
\title{Retrieve formulas from models fitted by \code{\link{bnec}}}
\usage{
\method{formula}{bayesnecfit}(x, ...)

\method{formula}{bayesmanecfit}(x, model, ...)
}
\arguments{
\item{x}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.}

\item{...}{Unused.}

\item{model}{A valid model string.}
}
\value{
An object of class \code{\link{bayesnecformula}}.
}
\description{
Retrieve formulas from models fitted by \code{\link{bnec}}.
\code{x} should be of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.
}
\examples{
\donttest{
library(bayesnec)
formula(manec_example, model = "nec4param")
nec4param <- pull_out(manec_example, "nec4param")
formula(nec4param)
}
}
