% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesfactor_savagedickey.R
\name{bayesfactor_savagedickey}
\alias{bayesfactor_savagedickey}
\alias{bayesfactor_savagedickey.numeric}
\alias{bayesfactor_savagedickey.stanreg}
\alias{bayesfactor_savagedickey.brmsfit}
\alias{bayesfactor_savagedickey.data.frame}
\title{Savage-Dickey density ratio Bayes Factor (BF)}
\usage{
bayesfactor_savagedickey(posterior, prior = NULL,
  direction = "two-sided", hypothesis = 0, verbose = TRUE, ...)

\method{bayesfactor_savagedickey}{numeric}(posterior, prior = NULL,
  direction = "two-sided", hypothesis = 0, verbose = TRUE, ...)

\method{bayesfactor_savagedickey}{stanreg}(posterior, prior = NULL,
  direction = "two-sided", hypothesis = 0, verbose = TRUE,
  effects = c("fixed", "random", "all"), ...)

\method{bayesfactor_savagedickey}{brmsfit}(posterior, prior = NULL,
  direction = "two-sided", hypothesis = 0, verbose = TRUE,
  effects = c("fixed", "random", "all"), ...)

\method{bayesfactor_savagedickey}{data.frame}(posterior, prior = NULL,
  direction = "two-sided", hypothesis = 0, verbose = TRUE, ...)
}
\arguments{
\item{posterior}{Vector representing a posterior distribution, or a \code{stanreg} / \code{brmsfit} object (see Details).}

\item{prior}{Vector representing a prior distribution (if \code{posterior} is a vector), or a data frame with column names matching \code{posterior}'s (if \code{posterior} is a data frame). Otherwise ignored.}

\item{direction}{Test type. One of \code{0}, \code{"two-sided"} (default, two tailed),
\code{-1}, \code{"left"} (left tailed) or \code{1}, \code{"right"} (right tailed).}

\item{hypothesis}{Value to be tested against (usually \code{0} in the context of null hypothesis testing).}

\item{verbose}{Toggle off warnings.}

\item{...}{Currently not used.}

\item{effects}{Should results for fixed effects, random effects or both be returned?
Only applies to mixed models. May be abbreviated.}
}
\value{
A data frame containing the Bayes factor representing evidence \emph{against} the (point) null effect model.
}
\description{
This method computes the ratio between the density of a single value (typically the null)
of two distributions. When the compared distributions are the posterior and the prior distributions,
this results in an approximation of a Bayes factor against the (point) null model.
}
\details{
This method is used to compute Bayes factors based on prior and posterior distributions.
When \code{posterior} is a model (\code{stanreg}, \code{brmsfit}), posterior and prior samples are
extracted for each parameter, and Savage-Dickey Bayes factors are computed for each parameter.
\cr \cr
\strong{NOTE:} For \code{brmsfit} models, the model must have been fitted with \emph{custom (non-default)} priors. See example below.
\cr \cr
A Bayes factor greater than 1 can be interpereted as evidence against the null,
at which one convention is that a Bayes factor greater than 3 can be considered
as "substantial" evidence against the null (and vice versa, a Bayes factor
smaller than 1/3 indicates substantial evidence in favor of the null-hypothesis)
(\cite{Wetzels et al. 2011}).
}
\examples{
library(bayestestR)

prior <- distribution_normal(1000, mean = 0, sd = 1)
posterior <- distribution_normal(1000, mean = .5, sd = .3)

bayesfactor_savagedickey(posterior, prior)

\dontrun{
# rstanarm models
# ---------------
library(rstanarm)
stan_model <- stan_lmer(extra ~ group + (1 | ID), data = sleep)
bayesfactor_savagedickey(stan_model)

# brms models
# -----------
library(brms)
my_custom_priors <-
  set_prior("student_t(3, 0, 1)", class = "b") +
  set_prior("student_t(3, 0, 1)", class = "sd", group = "ID")

brms_model <- brm(extra ~ group + (1 | ID),
  data = sleep,
  prior = my_custom_priors
)
bayesfactor_savagedickey(brms_model)
}

}
\references{
\itemize{
\item Wagenmakers, E. J., Lodewyckx, T., Kuriyal, H., and Grasman, R. (2010). Bayesian hypothesis testing for psychologists: A tutorial on the Savage-Dickey method. Cognitive psychology, 60(3), 158-189.
\item Wetzels, R., Matzke, D., Lee, M. D., Rouder, J. N., Iverson, G. J., and Wagenmakers, E.-J. (2011). Statistical Evidence in Experimental Psychology: An Empirical Comparison Using 855 t Tests. Perspectives on Psychological Science, 6(3), 291–298. \doi{10.1177/1745691611406923}
\item Heck, D. W. (2019). A caveat on the Savage–Dickey density ratio: The case of computing Bayes factors for regression parameters. British Journal of Mathematical and Statistical Psychology, 72(2), 316-333.
}
}
\author{
Mattan S. Ben-Shachar
}
