% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_correlation}
\alias{simulate_correlation}
\alias{simulate_ttest}
\title{Data Simulation}
\usage{
simulate_correlation(n = 100, r = 0.5, mean = 0, sd = 1,
  names = NULL, ...)

simulate_ttest(n = 100, d = 0.5, names = NULL, ...)
}
\arguments{
\item{n}{The number of observations to be generated.}

\item{r}{A value or vector corresponding to the desired correlation coefficients.}

\item{mean}{A value or vector corresponding to the mean of the variables.}

\item{sd}{A value or vector corresponding to the SD of the variables.}

\item{names}{A character vector of desired variable names.}

\item{...}{Arguments passed to or from other methods.}

\item{d}{A value or vector corresponding to the desired difference between the groups.}
}
\description{
Simulate data with specific characteristics.
}
\examples{

# Correlation --------------------------------
data <- simulate_correlation(r = 0.5)
plot(data$V1, data$V2)
cor.test(data$V1, data$V2)
summary(lm(V2 ~ V1, data = data))

# Specify mean and SD
data <- simulate_correlation(r = 0.5, n = 50, mean = c(0, 1), sd = c(0.7, 1.7))
cor.test(data$V1, data$V2)
round(c(mean(data$V1), sd(data$V1)), 1)
round(c(mean(data$V2), sd(data$V2)), 1)
summary(lm(V2 ~ V1, data = data))

# Generate multiple variables
cor_matrix <- matrix(c(
  1.0, 0.2, 0.4,
  0.2, 1.0, 0.3,
  0.4, 0.3, 1.0
),
nrow = 3
)

data <- simulate_correlation(r = cor_matrix, names = c("y", "x1", "x2"))
cor(data)
summary(lm(y ~ x1, data = data))

# t-test --------------------------------
data <- simulate_ttest(n = 30, d = 0.3)
plot(data$V1, data$V0)
round(c(mean(data$V1), sd(data$V1)), 1)
diff(t.test(data$V1 ~ data$V0)$estimate)
summary(lm(V1 ~ V0, data = data))
summary(glm(V0 ~ V1, data = data, family = "binomial"))
}
