% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_as.double.R
\name{as.double.qw}
\alias{as.double.qw}
\title{Numeric Representations}
\usage{
\method{as.double}{qw}(x, ...)
}
\arguments{
\item{x}{the object to be converted.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
A numeric representation of \code{x}, using a method commonly refered
to as simple substitution.
}
\description{
Converts data to numeric values: method for "qw" data.
}
\note{
The process of simple substitution proceeds in 4 steps for each kind of
censoring: none, interval, left and right.  First uncensored data are
retained as is. Interval-censored data are converted by computing the mid
rnge. Left-censored data are converted sequentially from the lowest
censoring level, which is set to 1/2 the reporting level, any subsequent
levels are replaced by the mean of all values less than the current reporting
level. Conversion of right-censored data are not implemented in the current version
and result in an error.\cr

The function \code{as.double} is executed for \code{as.numeric}.
}
\examples{

## Create a simple qw object 
Test.qw <- as.qw(c(1,2,3,2,4,4), c("<", "<", "<", " ", " ", " "), "", NA_real_,
"Miss", "None", "Mine", "TEST", "")
as.double(Test.qw)
as.numeric(Test.qw)

}
\keyword{internal}
\keyword{manip}
