% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_censorlevels.R
\name{censorLevels}
\alias{censorLevels}
\alias{censorLevels.default}
\alias{censorLevels.lcens}
\alias{censorLevels.mcens}
\alias{censorLevels.qw}
\title{Describe Censoring}
\usage{
censorLevels(x, type = "left")

\method{censorLevels}{default}(x, type = "left")

\method{censorLevels}{lcens}(x, type = "left")

\method{censorLevels}{mcens}(x, type = "left")

\method{censorLevels}{qw}(x, type = "left")
}
\arguments{
\item{x}{the object to get the levels of censoring.}

\item{type}{a character string indicating the type of censoring levels, must
be either "left" or "right."}
}
\value{
A numeric vector of the sorted censoring levels. If all data are
uncensored, then -Inf is returned for \code{type} = "left" and Inf is
returned for \code{type} = "right."
}
\description{
Returns all censoring levels for an object.  From smwrQW package.
}
\note{
Interval censoring is not characterized by a single value, so it is not
an option for \code{type}.
}
\examples{

censorLevels(2.3) # a simple number
censorLevels(as.lcens(1, 2)) # left-censored 

}
\seealso{
\code{\link{censoring}}
}
\keyword{attribute}
\keyword{censored}
\keyword{internal}
