% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qw.export.R
\name{qw.export}
\alias{qw.export}
\title{qw.export}
\usage{
qw.export(df.qw, dir.output = getwd(), fn.output = NULL)
}
\arguments{
\item{df.qw}{Data frame with qw fields to be exported.}

\item{dir.output}{Directory where output files will be saved. 
Default is working directory.}

\item{fn.output}{Name of output file.}
}
\value{
Returns a user named tab delimited files to the user defined directory with all of the qw slot data.
}
\description{
Export the contents of a QW object to comma delimited file (csv).
}
\details{
This internal function will export each qw field of a given data frame 
to separate columns in a single comma separated file (csv).  The left header information 
will be used "as is" but the data fields will be named with the qw column name 
and the qw slot names .Data.values, .Data.value2, and remark.codes (e.g., secchi..Data.values).  
These slots names will be renamed _lo, _hi, _symbol (e.g., secchi_lo). 
The remaning qw slot values will not be exported. 

The exported file will be in a directory specified by the user (defaults to working directory).
The file will be named as specified by the user.
}
\examples{
\dontrun{
# define data frame with qw column classes
myDF <- dataCensored

# directory to save output
dir.save <- getwd()

# prefix for file names ()
fn.out <- "data_censored_test.csv" 

# run function
qw.export(myDF, dir.save, fn.out)
}
}
