% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveDF.R
\name{saveDF}
\alias{saveDF}
\title{Save R object to disk}
\usage{
saveDF(
  rObj,
  note = NULL,
  rData = FALSE,
  csv = TRUE,
  attr = FALSE,
  timeStamp = TRUE,
  folder = "_save_df"
)
}
\arguments{
\item{rObj}{Name of R object to save.}

\item{note}{Suffix to include in file name.}

\item{rData}{Logical field to save rObj as an rData file (FALSE [default]).}

\item{csv}{Logical field to save rObj as an a csv file (TRUE [default]).}

\item{attr}{Logical field to save data frame attributes as a text file (FALSE [default]).}

\item{timeStamp}{Logical field to include date/time stamp in file name (TRUE [default]).}

\item{folder}{Subdirectory for saving file ('_save_df is default)}
}
\value{
Nothing returned. Saves R object to disk using csv and/or Rdata format.
}
\description{
Saves R object to disk using csv and/or Rdata format.
}
\details{
Output files are saved with an "rObj_note_YYYY_MM_DD_HHMMSS" naming
  convetion. By default, files are saved as csv files to a '_save_df'
  subdirectory relative to the working directory and include a time stamp in
  the file name using utils::write.csv. The default folder can be changed
  with the folder argument. Inclusion of a time stamp in the file name
  enables saving the same object at multiple steps through an R script, but
  can be turned off with the timeStamp argument. To also save object as rData
  file, set rData=TRUE.
}
\examples{
\dontrun{
df <- data.frame(x=c(1:100))
saveDF(df, 'test_note')
}

}
