% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library_with_dep.R, R/require_with_dep.R
\name{library_with_dep}
\alias{library_with_dep}
\alias{require_with_dep}
\title{Loading/Attaching and listing of packages with dependencies}
\usage{
library_with_dep(package, help, pos = 2, lib.loc = NULL,
  character.only = FALSE, logical.return = FALSE, warn.conflicts = TRUE,
  quietly = FALSE, verbose = getOption("verbose"), which = "Imports",
  recursive = FALSE, reverse = FALSE)

require_with_dep(package, lib.loc = NULL, quietly = FALSE,
  warn.conflicts = TRUE, character.only = FALSE, which = "Imports",
  recursive = FALSE, reverse = FALSE, verbose = getOption("verbose"))
}
\arguments{
\item{package}{the name of a package, given as a name or literal character string, 
or a character string, depending on whether character.only is 
\code{FALSE} (default) or \code{TRUE}.}

\item{help}{the name of a package, given as a name or literal character string, 
or a character string, depending on whether character.only is 
\code{FALSE} (default) or \code{TRUE}.}

\item{pos}{the position on the search list at which to attach 
the loaded namespace. 
Can also be the name of a position on the current 
search list as given by \code{\link[base]{search}}().}

\item{lib.loc}{character. A vector describing the location of R 
library trees to search through, or \code{NULL}. 
The default value of \code{NULL} corresponds to all libraries 
currently known to \code{\link[base]{.libPaths}}(). 
Non-existent library trees are silently ignored.}

\item{character.only}{logical. Indicates whether \code{package} or \code{help} 
can be assumed to be character strings.}

\item{logical.return}{logical. If it is \code{TRUE}, then \code{FALSE} or \code{TRUE} 
is returned to indicate success.}

\item{warn.conflicts}{logical. If \code{TRUE}, warnings are printed about 
conflicts from attaching the new package. 
A conflict is a function masking a function, 
or a non-function masking a non-function.}

\item{quietly}{logical. If \code{TRUE}, no message confirming package 
attaching is printed, and most often, 
no errors/warnings are printed if package attaching fails.}

\item{verbose}{logical. If \code{TRUE}, additional diagnostics are printed.}

\item{which}{character. A vector listing the types of dependencies, 
a subset of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}. 
Character string \code{"all"} is shorthand for that vector, 
character string \code{"most"} for the same vector without \code{"Enhances"}.}

\item{recursive}{logical. Should (reverse) dependencies of (reverse) 
dependencies (and so on) be included?}

\item{reverse}{logical. If \code{FALSE} (default), 
regular dependencies are calculated, otherwise reverse dependencies.}
}
\description{
\code{library_with_dep} and \code{require_with_dep} behave 
respectively like \code{\link[base]{library}} and 
\code{\link[base]{require}}, but also load and attach 
dependent packages (typically packages listed in the \code{Imports} 
field of the \code{DESCRIPTION} file).
}
\seealso{
\code{\link[base]{library}} and 
\code{\link[base]{require}} from package \pkg{base}; 
\code{\link[tools]{package_dependencies}} from \pkg{tools}; 
\code{\link[utils]{installed.packages}} from \pkg{utils}.
}
