% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArchiveBest.R
\name{ArchiveBest}
\alias{ArchiveBest}
\title{Minimal logging object for objective function evaluations}
\description{
The \link{ArchiveBest} stores no data but records the best scoring evaluation
passed to \verb{$add_evals()}. The \link{Archive} API is fully implemented but many
parameters are ignored and some methods do nothing. The archive still works
with \link{TerminatorClockTime}, \link{TerminatorEvals}, \link{TerminatorNone} and
\link{TerminatorEvals}.
}
\section{Super class}{
\code{\link[bbotk:Archive]{bbotk::Archive}} -> \code{ArchiveBest}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{n_evals}}{(\code{integer(1)})\cr
Number of evaluations stored in the archive.}

\item{\code{n_batch}}{(\code{integer(1)})\cr
Number of batches stored in the archive.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ArchiveBest-new}{\code{ArchiveBest$new()}}
\item \href{#method-ArchiveBest-add_evals}{\code{ArchiveBest$add_evals()}}
\item \href{#method-ArchiveBest-best}{\code{ArchiveBest$best()}}
\item \href{#method-ArchiveBest-clone}{\code{ArchiveBest$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="clear"><a href='../../bbotk/html/Archive.html#method-Archive-clear'><code>bbotk::Archive$clear()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="format"><a href='../../bbotk/html/Archive.html#method-Archive-format'><code>bbotk::Archive$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="nds_selection"><a href='../../bbotk/html/Archive.html#method-Archive-nds_selection'><code>bbotk::Archive$nds_selection()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Archive" data-id="print"><a href='../../bbotk/html/Archive.html#method-Archive-print'><code>bbotk::Archive$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBest-new"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBest-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBest$new(search_space, codomain, check_values = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies the search space for the \link{Optimizer}. The \link[paradox:ParamSet]{paradox::ParamSet}
describes either a subset of the \code{domain} of the \link{Objective} or it describes
a set of parameters together with a \code{trafo} function that transforms values
from the search space to values of the domain. Depending on the context, this
value defaults to the domain of the objective.}

\item{\code{codomain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies codomain of function.
Most importantly the tags of each output "Parameter" define whether it should
be minimized or maximized.  The default is to minimize each component.}

\item{\code{check_values}}{(\code{logical(1)})\cr
ignored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBest-add_evals"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBest-add_evals}{}}}
\subsection{Method \code{add_evals()}}{
Stores the best result in \code{ydt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBest$add_evals(xdt, xss_trafoed = NULL, ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Set of untransformed points / points from the \emph{search space}.
One point per row, e.g. \code{data.table(x1 = c(1, 3), x2 = c(2, 4))}.
Column names have to match ids of the \code{search_space}.
However, \code{xdt} can contain additional columns.}

\item{\code{xss_trafoed}}{(\code{list()})\cr
Transformed point(s) in the \emph{domain space}.}

\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Optimal outcome.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBest-best"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBest-best}{}}}
\subsection{Method \code{best()}}{
Returns the best scoring evaluation. For single-crit optimization,
the solution that minimizes / maximizes the objective function.
For multi-crit optimization, the Pareto set / front.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBest$best(m = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{m}}{(\code{integer()})\cr
ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ArchiveBest-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ArchiveBest-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArchiveBest$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
