% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObjectiveRFunDt.R
\name{ObjectiveRFunDt}
\alias{ObjectiveRFunDt}
\title{Objective interface for basic R functions.}
\description{
Objective interface where user can pass an R function that works on an \code{data.table()}.
}
\examples{
# define objective function
fun = function(xdt) {
  data.table::data.table(y = xdt$x1 + xdt$x2)
}

# set domain
domain = ps(
  x1 = p_dbl(-10, 10),
  x2 = p_dbl(-5, 5)
)

# set codomain
codomain = ps(
  y = p_dbl(tags = "maximize")
)

# create objective
objective = ObjectiveRFunDt$new(
  fun = fun,
  domain = domain,
  codomain = codomain,
  properties = "deterministic"
)

# evaluate objective function
objective$eval(list(x1 = 1, x2 = 2))

# evaluate multiple input values
objective$eval_many(list(list(x1 = 1, x2 = 2), list(x1 = 3, x2 = 4)))

# evaluate multiple input values as data.table
objective$eval_dt(data.table::data.table(x1 = 1:2, x2 = 3:4))
}
\seealso{
\link{ObjectiveRFun}, \link{ObjectiveRFunMany}
}
\section{Super class}{
\code{\link[bbotk:Objective]{bbotk::Objective}} -> \code{ObjectiveRFunDt}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fun}}{(\code{function})\cr
Objective function.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ObjectiveRFunDt-new}{\code{ObjectiveRFunDt$new()}}
\item \href{#method-ObjectiveRFunDt-eval_many}{\code{ObjectiveRFunDt$eval_many()}}
\item \href{#method-ObjectiveRFunDt-eval_dt}{\code{ObjectiveRFunDt$eval_dt()}}
\item \href{#method-ObjectiveRFunDt-clone}{\code{ObjectiveRFunDt$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="eval"><a href='../../bbotk/html/Objective.html#method-Objective-eval'><code>bbotk::Objective$eval()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="format"><a href='../../bbotk/html/Objective.html#method-Objective-format'><code>bbotk::Objective$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="help"><a href='../../bbotk/html/Objective.html#method-Objective-help'><code>bbotk::Objective$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Objective" data-id="print"><a href='../../bbotk/html/Objective.html#method-Objective-print'><code>bbotk::Objective$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ObjectiveRFunDt-new"></a>}}
\if{latex}{\out{\hypertarget{method-ObjectiveRFunDt-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunDt$new(
  fun,
  domain,
  codomain = NULL,
  id = "function",
  properties = character(),
  constants = ps(),
  packages = character(),
  check_values = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fun}}{(\code{function})\cr
R function that encodes objective and expects an \code{data.table()} as input
whereas each point is represented by one row.}

\item{\code{domain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies domain of function.
The \link[paradox:ParamSet]{paradox::ParamSet} should describe all possible input parameters of the objective function.
This includes their \code{id}, their types and the possible range.}

\item{\code{codomain}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Specifies codomain of function.
Most importantly the tags of each output "Parameter" define whether it should
be minimized or maximized.  The default is to minimize each component.}

\item{\code{id}}{(\code{character(1)}).}

\item{\code{properties}}{(\code{character()}).}

\item{\code{constants}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Changeable constants or parameters that are not subject to tuning can be stored and accessed here.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages to run the objective function.}

\item{\code{check_values}}{(\code{logical(1)})\cr
Should points before the evaluation and the results be checked for validity?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ObjectiveRFunDt-eval_many"></a>}}
\if{latex}{\out{\hypertarget{method-ObjectiveRFunDt-eval_many}{}}}
\subsection{Method \code{eval_many()}}{
Evaluates multiple input values received as a list, converted to a \code{data.table()} on the
objective function. Missing columns in xss are filled with \code{NA}s in \code{xdt}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunDt$eval_many(xss)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xss}}{(\code{list()})\cr
A list of lists that contains multiple x values, e.g.
\code{list(list(x1 = 1, x2 = 2), list(x1 = 3, x2 = 4))}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} that contains one y-column for single-criteria functions
and multiple y-columns for multi-criteria functions, e.g.
\code{data.table(y = 1:2)} or \code{data.table(y1 = 1:2, y2 = 3:4)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ObjectiveRFunDt-eval_dt"></a>}}
\if{latex}{\out{\hypertarget{method-ObjectiveRFunDt-eval_dt}{}}}
\subsection{Method \code{eval_dt()}}{
Evaluates multiple input values on the objective function supplied by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunDt$eval_dt(xdt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Set of untransformed points / points from the \emph{search space}.
One point per row, e.g. \code{data.table(x1 = c(1, 3), x2 = c(2, 4))}.
Column names have to match ids of the \code{search_space}.
However, \code{xdt} can contain additional columns.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data.table::data.table()] that contains one y-column for single-criteria functions
and multiple y-columns for multi-criteria functions, e.g.
\code{data.table(y = 1:2)} or \code{data.table(y1 = 1:2, y2 = 3:4)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ObjectiveRFunDt-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ObjectiveRFunDt-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ObjectiveRFunDt$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
