% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{dPosteriorPredictive.CatHDP}
\alias{dPosteriorPredictive.CatHDP}
\title{Posterior predictive density function of a "CatHDP" object}
\usage{
\method{dPosteriorPredictive}{CatHDP}(obj, z, k, j, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "CatHDP" object.}

\item{z}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{k}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{j}{integer, group label.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure: \cr
     G_j|gamma ~ DP(gamma,U), j = 1:J \cr
     pi_j|G_j,alpha ~ DP(alpha,G_j) \cr
     z|pi_j ~ Categorical(pi_j) \cr
     k|z,G_j ~ Categorical(G_j), if z is a sample from the base measure G \cr
where DP(gamma,U) is a Dirichlet Process on integers, gamma is the concentration parameter of the Dirichlet Process. DP(gamma,G_j) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_j. \cr
In the case of CatHDP, z and k can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatHDP" object. \cr
Posterior predictive is a distribution of z,k|alpha,gamm,U,G_j.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
@seealso \code{\link{CatHDP}}, \code{\link{dPosteriorPredictive.CatHDP}}
}
