% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{sufficientStatistics_Weighted.DP}
\alias{sufficientStatistics_Weighted.DP}
\title{Weighted sufficient statistics of a "DP" object}
\usage{
\method{sufficientStatistics_Weighted}{DP}(obj, x, w, ...)
}
\arguments{
\item{obj}{A "DP" object.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{w}{numeric, sample weights.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
Return the sufficient statistics of the corresponding BasicBayesian type, see examples.
}
\description{
For following model structure: \cr
Create an object of type "DP", which represents the Dirichlet-Process model structure: \cr
     pi|alpha ~ DP(alpha,U) \cr
     z|pi ~ Categorical(pi) \cr
     theta_z|psi ~ H0(psi) \cr
     x|theta_z,z ~ F(theta_z) \cr
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process. The choice of F() and H0() can be arbitrary, they are distributions of x and theta_z correspondingly. \cr
The sufficient statistics of a set of samples x in a "DP" object is the same sufficient statistics of the "BasicBayesian" inside the "DP", see examples.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{DP}}, \code{\link{sufficientStatistics.DP}}
}
