% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{sufficientStatistics_Weighted.GaussianNIW}
\alias{sufficientStatistics_Weighted.GaussianNIW}
\title{Weighted sufficient statistics for a "GaussianNIW" object}
\usage{
\method{sufficientStatistics_Weighted}{GaussianNIW}(obj, x, w, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{x, }{matrix, Gaussian samples, when x is a matrix, each row is a sample of dimension ncol(x). when x is a vector, x is length(x) samples of dimension 1.}

\item{w}{numeric, sample weights.}

\item{foreach}{logical, if foreach=TRUE, will return a list of sufficient statistics for each row of x, otherwise will return the sufficient statistics of x as a whole.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
If foreach=TRUE, will return a list of sufficient statistics for each row of x, otherwise will return the sufficient statistics of x as a whole.
}
\description{
For following Gaussian-NIW model structure: \cr
     theta|gamma ~ NIW(gamma) \cr
     x|theta ~ Gaussian(theta) \cr
where theta = (mu,Sigma) is the Gaussian parameter, gamma = (m,k,v,S) is the Normal-Inverse-Wishart(NIW) parameter. \cr
The sufficient statistics of a set of samples x (each row of x is a sample) and weights w are: \cr
 the effective number of samples N=sum(w); \cr
 the sample sum xsum = colSums(x*w); \cr
 the uncentered scatter matrix S = t(w*x)%*%x.
}
\examples{
x <- rGaussian(10,mu = c(-1.5,1.5),Sigma = matrix(c(0.1,0.03,0.03,0.1),2,2))
obj <- GaussianNIW()                    #an GaussianNIW object
w <- runif(10)
sufficientStatistics_Weighted(obj=obj,x=x,w=w,foreach = FALSE)
sufficientStatistics_Weighted(obj=obj,x=x,w=w,foreach = TRUE)
}
\references{
Murphy, Kevin P. "Conjugate Bayesian analysis of the Gaussian distribution." def 1.22 (2007): 16.

Gelman, Andrew, et al. "Bayesian Data Analysis Chapman & Hall." CRC Texts in Statistical Science (2004).
}
\seealso{
\code{\link{GaussianNIW}}, \code{\link{sufficientStatistics.GaussianNIW}}
}
